<?php

use Doctrine\DBAL\DriverManager;
use Dealerdirect\Deliveries\Config;
use Dealerdirect\Deliveries\Delivery;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Deliveries\Repositories\CarNlRepository;

require_once dirname(__DIR__) . '/vendor/autoload.php';

// Set Bid ID
$bidId = 0; // 26390661
$userId = 0;
$ipAddress = '192.168.1.1';
$dateOfBirth = '01-01-1991';

$connection = DriverManager::getConnection(
    [
       'dbname' => 'dealer01_ddmain',
       'user' => 'vagrant',
       'password' => 'vagrant',
       'host' => 'aio.test',
       'driver' => 'pdo_mysql',
       'charset'  => 'utf8mb4',
    ],
    new \Doctrine\DBAL\Configuration()
);

$delivery = new Delivery(
    new CarNlRepository($connection),
    new Config([
        Config::DEALER_SITE_IMPERSONATE_KEY => 'R72SaMOwBou595zLuW1HtPHkYZd6og1T',
        Config::SALES_AGREEMENT_LOCATION => 'file:///tmp/verkoopovereenkomsten/',
        Config::EMAIL_SERVICE_API_URL => 'https://email-service.email-service.test/api/v1',
        Config::DEALER_SITE_URL => 'https://dealerdirect.eu.aio.test',
        Config::VONAGE_API_KEY => 'fake_key', // 'efd39e7a'
        Config::VONAGE_API_SECRET => 'fake_secret', //'55e91d15'
    ])
);

$deliverId = $delivery->addSale($bidId, $userId, $ipAddress, new DateTime($dateOfBirth));
if ($delivery->sendAgreements($deliverId, $ipAddress)) {
    $delivery->sendAgreeSaleSms(
        VehicleType::CAR,
        'NL',
        $deliverId,
        $ipAddress
    );
}
