<?php

declare(strict_types=1);

namespace Dealerdirect\Deliveries;

use Dealerdirect\Deliveries\Exceptions\ConfigException;
use PHPUnit\Framework\TestCase;

class ConfigTest extends TestCase
{
    /**
     * @covers Config::__construct()
     */
    public function testInstantiateConfigShouldThrowExceptionOnMissingRequiredKeys()
    {
        $this->expectException(ConfigException::class);
        $missingKeys = array_keys($this->fixtureGetValidConfigParams());

        foreach ($missingKeys as $missingKey) {
            $this->expectExceptionMessageMatches("/{$missingKey}/");
        }

        new Config([]);
    }

    /**
     * @covers Config::get()
     */
    public function testGetValueWithValidConfigClass()
    {
        $expected = 'https://www.test.com';

        $config = new Config($this->fixtureGetValidConfigParams());
        $actual = $config->get(Config::EMAIL_SERVICE_API_URL);

        $this->assertEquals($expected, $actual);
    }

    /**
     * @covers Config::all()
     */
    public function testGetAllWithValidConfigClass()
    {
        $expected = $this->fixtureGetValidConfigParams();

        $config = new Config($this->fixtureGetValidConfigParams());
        $actual = $config->all();

        $this->assertEquals($expected, $actual);
    }

    public function fixtureGetValidConfigParams()
    {
        return [
            Config::EMAIL_SERVICE_API_URL => 'https://www.test.com',
            Config::SALES_AGREEMENT_LOCATION => '//tmp',
            Config::DEALER_SITE_IMPERSONATE_KEY => '123456789',
            Config::DEALER_SITE_URL => 'https://www.dealerdirect.eu',
            Config::VONAGE_API_KEY => 'api-key',
            Config::VONAGE_API_SECRET => 'api-secret',
        ];
    }
}
