<?php

namespace Dealerdirect\Deliveries\Exceptions;

class RepositoryException extends DeliveryException
{
    public static function commit()
    {
        return new static('Add sale failed! Could not commit changes');
    }

    /**
     * Exception for insert with table and params
     *
     * @param string $table
     * @param array $params
     * @return AddSaleException
     */
    public static function insert(string $table, array $params)
    {
        $params = self::arrayToString($params);

        return new static("Insert into '$table' error with [$params].");
    }

    /**
     * Exception for empty data; Fetched by database.
     *
     * @param array $params
     * @return AddSaleException
     */
    public static function emptyData(string $query, array $params)
    {
        return new static(sprintf(
            'Empty data with [Query: "%s"; Params: %s]',
            str_replace(["\r", "\n", "\r\n", "\t", '  '], ' ', $query),
            self::arrayToString($params)
        ));
    }
}
