<?php

use Dealerdirect\Deliveries\Delivery;
use Dealerdirect\Deliveries\Repositories\CarNlRepository;
use DealerDirect\Generic\Category\Site;
use Doctrine\DBAL\DriverManager;

require_once dirname(__DIR__) . '/vendor/autoload.php';

// Set Bid ID
$bidId = 0; // 26390661
$userId = 0;
$ipAddress = '192.168.1.1';
$dateOfBirth = '01-01-1991';

$connection = DriverManager::getConnection([
    'dbname' => 'dealer01_ddmain',
    'user' => 'vagrant',
    'password' => 'vagrant',
    'host' => 'aio.test',
    'driver' => 'pdo_mysql',
    'charset' => 'utf8mb4',
], new \Doctrine\DBAL\Configuration());

try {
    // Option 1
    $delivery = new Delivery(
        new CarNlRepository($connection)
    );

    // OR Option 2
    // $delivery = Delivery::constructWithReference(Site::REF_CAR_MARKTPLAATS_NL, $connection);

    // Add sale
    $deliverId = $delivery->addSale($bidId, $userId, $ipAddress, new DateTime($dateOfBirth));

    echo "Sale added with deliver ID: {$deliverId}\n";
} catch (\Exception $e) {
    echo $e->getMessage();
}
