<?php

namespace Dealerdirect\Deliveries\Exceptions;

use DateTime;

class DeliveryException extends \Exception
{
    /**
     * @param array $array
     * @return string
     */
    protected static function arrayToString(array $array)
    {
        return implode(', ', array_map(
            function ($value, $key) {
                return sprintf("%s: %s", $key, $value instanceof DateTime ? $value->format('d-m-Y') : $value);
            },
            $array,
            array_keys($array)
        ));
    }

    /**
     * @param string $branch
     * @return DeliveryException
     */
    public static function invalidBranch($branch)
    {
        return new static("Invalid branch '$branch'.");
    }

    /**
     * @param integer $reference
     * @return DeliveryException
     */
    public static function invalidReference($reference, array $available)
    {
        $available = implode(', ', array_keys($available));

        return new static("Invalid reference '$reference'. Available references: [$available]");
    }
}
