<?php

namespace Dealerdirect\Deliveries;

use ReflectionClass;
use Dealerdirect\Deliveries\Exceptions\ConfigException;

class Config
{
    public const EMAIL_SERVICE_API_URL = 'emailServiceApiUrl';
    public const SALES_AGREEMENT_LOCATION = 'salesAgreementLocation';
    public const DEALER_SITE_IMPERSONATE_KEY = 'dealerSiteImpersonateKey';
    public const DEALER_SITE_URL = 'dealerSiteUrl';
    public const VONAGE_API_KEY = 'vonageApiKey';
    public const VONAGE_API_SECRET = 'vonageApiSecret';

    private $data = [];

    public function __construct(array $config)
    {
        $required = (new ReflectionClass($this))->getConstants();
        $missingKeys = [];
        foreach ($required as $key) {
            if (!array_key_exists($key, $config)) {
                $missingKeys[] = $key;
                continue;
            }

            $this->data[$key] = $config[$key];
        }

        if (!empty($missingKeys)) {
            throw ConfigException::missingKeys($missingKeys);
        }
    }

    public function get($property)
    {
        return $this->data[$property] ?? null;
    }

    public function all()
    {
        return $this->data;
    }
}
