<?php

declare(strict_types=1);

namespace Dealerdirect\Deliveries;

use Dealerdirect\Deliveries\Repositories\AbstractRepository;
use Dealerdirect\Deliveries\Repositories\BicycleNlRepository;
use Dealerdirect\Deliveries\Repositories\CarBeRepository;
use Dealerdirect\Deliveries\Repositories\CarDeRepository;
use Dealerdirect\Deliveries\Repositories\CarNlRepository;
use Dealerdirect\Deliveries\Repositories\MotorBeRepository;
use Dealerdirect\Deliveries\Repositories\MotorDeRepository;
use Dealerdirect\Deliveries\Repositories\MotorNlRepository;
use Dealerdirect\Deliveries\Repositories\ScooterNlRepository;
use DealerDirect\Generic\Category\Territory;
use DealerDirect\Generic\Category\VehicleType;
use Doctrine\DBAL\Connection;
use PHPUnit\Framework\TestCase;

class RepositoryTest extends TestCase
{
    /**
     * @covers \Dealerdirect\Deliveries\Repositories\AbstractRepository
     * @dataProvider provideValidVehicleTypeAndCountryCodes
     */
    public function testRepositoriesHaveCorrectVehicleTypeAndCountryCode(
        $repositoryClass,
        $expectedVehicleType,
        $expectedCountryCode
    ) {
        /** @var AbstractRepository $repository */
        $repository = new $repositoryClass($this->fixtureGetConnection());

        $this->assertEquals($expectedVehicleType, $repository->getVehicleType());
        $this->assertEquals($expectedCountryCode, $repository->getCountryCode());
    }

    public static function provideValidVehicleTypeAndCountryCodes()
    {
        return [
            'car_nl' => [CarNlRepository::class, VehicleType::CAR, Territory::NL],
            'car_be' => [CarBeRepository::class, VehicleType::CAR, Territory::BE],
            'car_de' => [CarDeRepository::class, VehicleType::CAR, Territory::DE],
            'motor_nl' => [MotorNlRepository::class, VehicleType::MOTOR, Territory::NL],
            'motor_be' => [MotorBeRepository::class, VehicleType::MOTOR, Territory::BE],
            'motor_de' => [MotorDeRepository::class, VehicleType::MOTOR, Territory::DE],
            'scooter_nl' => [ScooterNlRepository::class, VehicleType::SCOOTER, Territory::NL],
            'bicycle_nl' => [BicycleNlRepository::class, VehicleType::BICYCLE, Territory::NL],
        ];
    }

    public function fixtureGetConnection()
    {
        return $this->createStub(Connection::class);
    }
}
