# Generating a SDK

## Introduction

This repository contains both the code to generate a PHP SDK for the email service
_and_ the generated SDK code.

The [Swagger Codegen][swagger-codegen] is used to generate code.

## Usage

To release a new SDK, three steps are needed:

1. Update the `swagger.json`
2. Generate the SDK
3. Release the changes

### Updating the `swagger.json` file

The `swagger.json` file, used to generate the SDK, is provided by the [Dealerdirect Email Service][email-service]. Please refer to that project's documentation for
instructions on how to attain a new JSON file.

### Generating the SDK

Generating a SDK has been fully automated. Once the `swagger.json` in this
repository has been changed, all that is needed is to call the generation script:

    ./bin/generate-email-service-sdk

The script will walk through the following steps:

- Validate all dependencies are present (`composer`, `java`, `php`, `sed`)
- Validate de Swagger CodeGen JAR is present (or try to download it if it is not)
- Install the projects dependencies (i.e. run `composer install`)
- Generate the SDK code using the Swagger CodeGen JAR file
- Run `php-cs-fixer` to cleanup the generated code to mathc PSR standards
- Fix make minor changes to the generated `README` and `composer.json` files
- Remove generated files that are not needed

### Releasing the changes

Once the generated changes have been reviewed, the changes can be committed and
a new release can be tagged.

[swagger-codegen]: https://github.com/swagger-api/swagger-codegen
[email-service]: https://git.dealerdirect.io/apis/email-service/
