<?php

/**
 * Attachment
 *
 * PHP version 5
 *
 * @category Class
 * @package  Dealerdirect\EmailServiceSdk
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Email Service API
 *
 * The API description for the email service.
 *
 * OpenAPI spec version: 0.1.0
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Dealerdirect\EmailServiceSdk\Model;

use ArrayAccess;

/**
 * Attachment Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\EmailServiceSdk
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class Attachment implements ArrayAccess
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $swaggerModelName = 'Attachment';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $swaggerTypes = [
        'content' => 'string',
        'fileName' => 'string',
        'mimeType' => 'string',
        'disposition' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'content' => 'content',
        'fileName' => 'file_name',
        'mimeType' => 'mime_type',
        'disposition' => 'disposition'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'content' => 'setContent',
        'fileName' => 'setFileName',
        'mimeType' => 'setMimeType',
        'disposition' => 'setDisposition'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'content' => 'getContent',
        'fileName' => 'getFileName',
        'mimeType' => 'getMimeType',
        'disposition' => 'getDisposition'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    public const DISPOSITION_ATTACHMENT = 'attachment';



    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDispositionAllowableValues()
    {
        return [
            self::DISPOSITION_ATTACHMENT,
        ];
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['content'] = isset($data['content']) ? $data['content'] : null;
        $this->container['fileName'] = isset($data['fileName']) ? $data['fileName'] : null;
        $this->container['mimeType'] = isset($data['mimeType']) ? $data['mimeType'] : null;
        $this->container['disposition'] = isset($data['disposition']) ? $data['disposition'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['content'] === null) {
            $invalid_properties[] = "'content' can't be null";
        }
        if ($this->container['fileName'] === null) {
            $invalid_properties[] = "'fileName' can't be null";
        }
        if ($this->container['mimeType'] === null) {
            $invalid_properties[] = "'mimeType' can't be null";
        }
        if ($this->container['disposition'] === null) {
            $invalid_properties[] = "'disposition' can't be null";
        }
        $allowed_values = ["attachment"];
        if (!in_array($this->container['disposition'], $allowed_values, true)) {
            $invalid_properties[] = "invalid value for 'disposition', must be one of 'attachment'.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        if ($this->container['content'] === null) {
            return false;
        }
        if ($this->container['fileName'] === null) {
            return false;
        }
        if ($this->container['mimeType'] === null) {
            return false;
        }
        if ($this->container['disposition'] === null) {
            return false;
        }
        $allowed_values = ["attachment"];
        if (!in_array($this->container['disposition'], $allowed_values, true)) {
            return false;
        }
        return true;
    }


    /**
     * Gets content
     *
     * @return string
     */
    public function getContent()
    {
        return $this->container['content'];
    }

    /**
     * Sets content
     *
     * @param  string $content The base64 encoded content of the attached file
     * @return $this
     */
    public function setContent($content)
    {
        $this->container['content'] = $content;

        return $this;
    }

    /**
     * Gets fileName
     *
     * @return string
     */
    public function getFileName()
    {
        return $this->container['fileName'];
    }

    /**
     * Sets fileName
     *
     * @param  string $fileName The name of the attached file
     * @return $this
     */
    public function setFileName($fileName)
    {
        $this->container['fileName'] = $fileName;

        return $this;
    }

    /**
     * Gets mimeType
     *
     * @return string
     */
    public function getMimeType()
    {
        return $this->container['mimeType'];
    }

    /**
     * Sets mimeType
     *
     * @param  string $mimeType The MIME type of the attached file
     * @return $this
     */
    public function setMimeType($mimeType)
    {
        $this->container['mimeType'] = $mimeType;

        return $this;
    }

    /**
     * Gets disposition
     *
     * @return string
     */
    public function getDisposition()
    {
        return $this->container['disposition'];
    }

    /**
     * Sets disposition
     *
     * @param  string $disposition The content disposition of the attached file.
     * @return $this
     */
    public function setDisposition($disposition)
    {
        $allowed_values = ['attachment'];
        if ((!in_array($disposition, $allowed_values, true))) {
            throw new \InvalidArgumentException("Invalid value for 'disposition', must be one of 'attachment'");
        }
        $this->container['disposition'] = $disposition;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Dealerdirect\EmailServiceSdk\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Dealerdirect\EmailServiceSdk\ObjectSerializer::sanitizeForSerialization($this));
    }
}
