<?php
/**
 * ListEmailsApi
 * PHP version 5
 *
 * @category Class
 * @package  Dealerdirect\EmailServiceSdk
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Email Service API
 *
 * The API description for the email service.
 *
 * OpenAPI spec version: 0.1.0
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Dealerdirect\EmailServiceSdk\Api;

use \Dealerdirect\EmailServiceSdk\ApiClient;
use \Dealerdirect\EmailServiceSdk\ApiException;
use \Dealerdirect\EmailServiceSdk\Configuration;
use \Dealerdirect\EmailServiceSdk\ObjectSerializer;

/**
 * ListEmailsApi Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\EmailServiceSdk
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListEmailsApi
{
    /**
     * API Client
     *
     * @var \Dealerdirect\EmailServiceSdk\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Dealerdirect\EmailServiceSdk\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Dealerdirect\EmailServiceSdk\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Dealerdirect\EmailServiceSdk\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Dealerdirect\EmailServiceSdk\ApiClient $apiClient set the API client
     *
     * @return ListEmailsApi
     */
    public function setApiClient(\Dealerdirect\EmailServiceSdk\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation emailsGet
     *
     * Returns a list of created Emails.
     *
     * @throws \Dealerdirect\EmailServiceSdk\ApiException on non-2xx response
     * @return \Dealerdirect\EmailServiceSdk\Model\Todo[]
     */
    public function emailsGet()
    {
        list($response) = $this->emailsGetWithHttpInfo();
        return $response;
    }

    /**
     * Operation emailsGetWithHttpInfo
     *
     * Returns a list of created Emails.
     *
     * @throws \Dealerdirect\EmailServiceSdk\ApiException on non-2xx response
     * @return array of \Dealerdirect\EmailServiceSdk\Model\Todo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function emailsGetWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/emails";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Dealerdirect\EmailServiceSdk\Model\Todo[]',
                '/emails'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Dealerdirect\EmailServiceSdk\Model\Todo[]', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Dealerdirect\EmailServiceSdk\Model\Todo[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Dealerdirect\EmailServiceSdk\Model\ClientError', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Dealerdirect\EmailServiceSdk\Model\ServerError', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
