<?php
/**
 * SendEmailApi
 * PHP version 5
 *
 * @category Class
 * @package  Dealerdirect\EmailServiceSdk
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Email Service API
 *
 * The API description for the email service.
 *
 * OpenAPI spec version: 0.1.0
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Dealerdirect\EmailServiceSdk\Api;

use \Dealerdirect\EmailServiceSdk\ApiClient;
use \Dealerdirect\EmailServiceSdk\ApiException;
use \Dealerdirect\EmailServiceSdk\Configuration;
use \Dealerdirect\EmailServiceSdk\ObjectSerializer;

/**
 * SendEmailApi Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\EmailServiceSdk
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SendEmailApi
{
    /**
     * API Client
     *
     * @var \Dealerdirect\EmailServiceSdk\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Dealerdirect\EmailServiceSdk\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Dealerdirect\EmailServiceSdk\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Dealerdirect\EmailServiceSdk\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Dealerdirect\EmailServiceSdk\ApiClient $apiClient set the API client
     *
     * @return SendEmailApi
     */
    public function setApiClient(\Dealerdirect\EmailServiceSdk\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation emailsPost
     *
     * Send an email
     *
     * @param \Dealerdirect\EmailServiceSdk\Model\EmailPayload $email  (required)
     * @throws \Dealerdirect\EmailServiceSdk\ApiException on non-2xx response
     * @return void
     */
    public function emailsPost($email)
    {
        list($response) = $this->emailsPostWithHttpInfo($email);
        return $response;
    }

    /**
     * Operation emailsPostWithHttpInfo
     *
     * Send an email
     *
     * @param \Dealerdirect\EmailServiceSdk\Model\EmailPayload $email  (required)
     * @throws \Dealerdirect\EmailServiceSdk\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function emailsPostWithHttpInfo($email)
    {
        // verify the required parameter 'email' is set
        if ($email === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email when calling emailsPost');
        }
        // parse inputs
        $resourcePath = "/emails";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($email)) {
            $_tempBody = $email;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/emails'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Dealerdirect\EmailServiceSdk\Model\ClientError', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Dealerdirect\EmailServiceSdk\Model\ServerError', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
