# Dealerdirect Email Service SDK

The API description for the email service.

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.1.0
- Build package: io.swagger.codegen.languages.PhpClientCodegen

## Requirements

PHP 5.4.0 and later

## Installation & Usage

_**For documentation on generating a new SDK see [here](./docs/generating-sdk.md).**_

### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "git@git.dealerdirect.io:php-packages/email-service-sdk.git"
    }
  ]
}
```

Then run `composer require dealerdirect/email-service-sdk`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to//autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Dealerdirect\EmailServiceSdk\Api\ListEmailsApi();

try {
    $result = $api_instance->emailsGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ListEmailsApi->emailsGet: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://email-service.email-service.dev/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ListEmailsApi* | [**emailsGet**](docs/Api/ListEmailsApi.md#emailsget) | **GET** /emails | Returns a list of created Emails.
*SendEmailApi* | [**emailsPost**](docs/Api/SendEmailApi.md#emailspost) | **POST** /emails | Send an email

## Documentation For Models

 - [Bcc](docs/Model/Bcc.md)
 - [Cc](docs/Model/Cc.md)
 - [ClientError](docs/Model/ClientError.md)
 - [Email](docs/Model/Email.md)
 - [EmailAddress](docs/Model/EmailAddress.md)
 - [EmailPayload](docs/Model/EmailPayload.md)
 - [EmailType](docs/Model/EmailType.md)
 - [Error](docs/Model/Error.md)
 - [Locale](docs/Model/Locale.md)
 - [LotType](docs/Model/LotType.md)
 - [Response](docs/Model/Response.md)
 - [ServerError](docs/Model/ServerError.md)
 - [To](docs/Model/To.md)

## Documentation For Authorization

 All endpoints do not require authorization.
