<?php

/**
 * Email
 *
 * PHP version 5
 *
 * @category Class
 * @package  Dealerdirect\EmailServiceSdk
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Email Service API
 *
 * The API description for the email service.
 *
 * OpenAPI spec version: 0.1.0
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Dealerdirect\EmailServiceSdk\Model;

use ArrayAccess;

/**
 * Email Class Doc Comment
 *
 * @category    Class
 * @package     Dealerdirect\EmailServiceSdk
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Email implements ArrayAccess
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Email';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'locale' => '\Dealerdirect\EmailServiceSdk\Model\Locale',
        'emailType' => '\Dealerdirect\EmailServiceSdk\Model\EmailType',
        'lotType' => '\Dealerdirect\EmailServiceSdk\Model\LotType',
        'substitutions' => 'object',
        'to' => '\Dealerdirect\EmailServiceSdk\Model\To[]',
        'cc' => '\Dealerdirect\EmailServiceSdk\Model\Cc[]',
        'bcc' => '\Dealerdirect\EmailServiceSdk\Model\Bcc[]',
        'attachments' => '\Dealerdirect\EmailServiceSdk\Model\Attachment[]'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'locale' => 'locale',
        'emailType' => 'email_type',
        'lotType' => 'lot_type',
        'substitutions' => 'substitutions',
        'to' => 'to',
        'cc' => 'cc',
        'bcc' => 'bcc',
        'attachments' => 'attachments'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'locale' => 'setLocale',
        'emailType' => 'setEmailType',
        'lotType' => 'setLotType',
        'substitutions' => 'setSubstitutions',
        'to' => 'setTo',
        'cc' => 'setCc',
        'bcc' => 'setBcc',
        'attachments' => 'setAttachments'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'locale' => 'getLocale',
        'emailType' => 'getEmailType',
        'lotType' => 'getLotType',
        'substitutions' => 'getSubstitutions',
        'to' => 'getTo',
        'cc' => 'getCc',
        'bcc' => 'getBcc',
        'attachments' => 'getAttachments'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['emailType'] = isset($data['emailType']) ? $data['emailType'] : null;
        $this->container['lotType'] = isset($data['lotType']) ? $data['lotType'] : null;
        $this->container['substitutions'] = isset($data['substitutions']) ? $data['substitutions'] : null;
        $this->container['to'] = isset($data['to']) ? $data['to'] : null;
        $this->container['cc'] = isset($data['cc']) ? $data['cc'] : null;
        $this->container['bcc'] = isset($data['bcc']) ? $data['bcc'] : null;
        $this->container['attachments'] = isset($data['attachments']) ? $data['attachments'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['locale'] === null) {
            $invalid_properties[] = "'locale' can't be null";
        }
        if ($this->container['emailType'] === null) {
            $invalid_properties[] = "'emailType' can't be null";
        }
        if ($this->container['lotType'] === null) {
            $invalid_properties[] = "'lotType' can't be null";
        }
        if ($this->container['to'] === null) {
            $invalid_properties[] = "'to' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        if ($this->container['locale'] === null) {
            return false;
        }
        if ($this->container['emailType'] === null) {
            return false;
        }
        if ($this->container['lotType'] === null) {
            return false;
        }
        if ($this->container['to'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets locale
     * @return \Dealerdirect\EmailServiceSdk\Model\Locale
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     * @param \Dealerdirect\EmailServiceSdk\Model\Locale $locale
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets emailType
     * @return \Dealerdirect\EmailServiceSdk\Model\EmailType
     */
    public function getEmailType()
    {
        return $this->container['emailType'];
    }

    /**
     * Sets emailType
     * @param \Dealerdirect\EmailServiceSdk\Model\EmailType $emailType
     * @return $this
     */
    public function setEmailType($emailType)
    {
        $this->container['emailType'] = $emailType;

        return $this;
    }

    /**
     * Gets lotType
     * @return \Dealerdirect\EmailServiceSdk\Model\LotType
     */
    public function getLotType()
    {
        return $this->container['lotType'];
    }

    /**
     * Sets lotType
     * @param \Dealerdirect\EmailServiceSdk\Model\LotType $lotType
     * @return $this
     */
    public function setLotType($lotType)
    {
        $this->container['lotType'] = $lotType;

        return $this;
    }

    /**
     * Gets substitutions
     * @return object
     */
    public function getSubstitutions()
    {
        return $this->container['substitutions'];
    }

    /**
     * Sets substitutions
     * @param object $substitutions Key value pairs with which placeholders in templates should be substituted
     * @return $this
     */
    public function setSubstitutions($substitutions)
    {
        $this->container['substitutions'] = $substitutions;

        return $this;
    }

    /**
     * Gets to
     * @return \Dealerdirect\EmailServiceSdk\Model\To[]
     */
    public function getTo()
    {
        return $this->container['to'];
    }

    /**
     * Sets to
     * @param \Dealerdirect\EmailServiceSdk\Model\To[] $to
     * @return $this
     */
    public function setTo($to)
    {
        $this->container['to'] = $to;

        return $this;
    }

    /**
     * Gets cc
     * @return \Dealerdirect\EmailServiceSdk\Model\Cc[]
     */
    public function getCc()
    {
        return $this->container['cc'];
    }

    /**
     * Sets cc
     * @param \Dealerdirect\EmailServiceSdk\Model\Cc[] $cc
     * @return $this
     */
    public function setCc($cc)
    {
        $this->container['cc'] = $cc;

        return $this;
    }

    /**
     * Gets bcc
     * @return \Dealerdirect\EmailServiceSdk\Model\Bcc[]
     */
    public function getBcc()
    {
        return $this->container['bcc'];
    }

    /**
     * Sets bcc
     * @param \Dealerdirect\EmailServiceSdk\Model\Bcc[] $bcc
     * @return $this
     */
    public function setBcc($bcc)
    {
        $this->container['bcc'] = $bcc;

        return $this;
    }

    /**
     * Gets attachments
     * @return \Dealerdirect\EmailServiceSdk\Model\Attachment[]
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     * @param \Dealerdirect\EmailServiceSdk\Model\Attachment[] $attachments
     * @return $this
     */
    public function setAttachments($attachments)
    {
        $this->container['attachments'] = $attachments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Dealerdirect\EmailServiceSdk\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Dealerdirect\EmailServiceSdk\ObjectSerializer::sanitizeForSerialization($this));
    }
}
