<?php

/**
 * Response
 *
 * PHP version 5
 *
 * @category Class
 * @package  Dealerdirect\EmailServiceSdk
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Email Service API
 *
 * The API description for the email service.
 *
 * OpenAPI spec version: 0.1.0
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Dealerdirect\EmailServiceSdk\Model;

use ArrayAccess;

/**
 * Response Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\EmailServiceSdk
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class Response implements ArrayAccess
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $swaggerModelName = 'Response';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $swaggerTypes = [
        'status' => 'string',
        'code' => 'int',
        'message' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'status' => 'status',
        'code' => 'code',
        'message' => 'message'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'status' => 'setStatus',
        'code' => 'setCode',
        'message' => 'setMessage'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'status' => 'getStatus',
        'code' => 'getCode',
        'message' => 'getMessage'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_ERROR = 'error';
    public const STATUS_FAIL = 'fail';
    public const STATUS_SUCCESS = 'success';



    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_ERROR,
            self::STATUS_FAIL,
            self::STATUS_SUCCESS,
        ];
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['code'] = isset($data['code']) ? $data['code'] : null;
        $this->container['message'] = isset($data['message']) ? $data['message'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['status'] === null) {
            $invalid_properties[] = "'status' can't be null";
        }
        $allowed_values = ["error", "fail", "success"];
        if (!in_array($this->container['status'], $allowed_values, true)) {
            $invalid_properties[] = "invalid value for 'status', must be one of 'error', 'fail', 'success'.";
        }

        if ($this->container['code'] === null) {
            $invalid_properties[] = "'code' can't be null";
        }
        if (($this->container['code'] > 599)) {
            $invalid_properties[] = "invalid value for 'code', must be smaller than or equal to 599.";
        }

        if (($this->container['code'] < 200)) {
            $invalid_properties[] = "invalid value for 'code', must be bigger than or equal to 200.";
        }

        if ($this->container['message'] === null) {
            $invalid_properties[] = "'message' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        if ($this->container['status'] === null) {
            return false;
        }
        $allowed_values = ["error", "fail", "success"];
        if (!in_array($this->container['status'], $allowed_values, true)) {
            return false;
        }
        if ($this->container['code'] === null) {
            return false;
        }
        if ($this->container['code'] > 599) {
            return false;
        }
        if ($this->container['code'] < 200) {
            return false;
        }
        if ($this->container['message'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param  string $status HTTP Status  Can be either \"success\" for successful requests, \"fail\" for client errors or \"error\" for server errors.
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = ['error', 'fail', 'success'];
        if ((!in_array($status, $allowed_values, true))) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'error', 'fail', 'success'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets code
     *
     * @return int
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param  int $code HTTP Status Code  Can be 200 - 299 range for success, 400 - 499 for client errors or 500 - 599 for server errors.
     * @return $this
     */
    public function setCode($code)
    {
        if (($code > 599)) {
            throw new \InvalidArgumentException('invalid value for $code when calling Response., must be smaller than or equal to 599.');
        }
        if (($code < 200)) {
            throw new \InvalidArgumentException('invalid value for $code when calling Response., must be bigger than or equal to 200.');
        }

        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets message
     *
     * @return string
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     *
     * @param  string $message HTTP Status Message  A more detailed description of the status
     * @return $this
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Dealerdirect\EmailServiceSdk\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Dealerdirect\EmailServiceSdk\ObjectSerializer::sanitizeForSerialization($this));
    }
}
