<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use DealerDirect\Generic\Category\Site;
use Dealerdirect\Emails\Traits\EncryptHash;
use Dealerdirect\Emails\Traits\ConsumerData;
use Dealerdirect\Emails\Traits\ConsumerDomains;
use DealerDirect\Generic\Category\EmailType;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class RequestPhone extends Mailer
{
    use ConsumerData;
    use EncryptHash;
    use ConsumerDomains;

    /** @var string */
    protected $emailType = EmailType::REQUEST_PHONE;

    public function __invoke(): void
    {
        $this->setData();

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::LOT_NUMBER => $this->id,
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::URL => $this->getUrl(),
        ]);

        $this->send();
    }

    private function getUrl()
    {
        $domain = $this->getDomainByReference((int) $this->data['reference']);
        $encryptedId = $this->encryptHash($this->id);
        $endPoint = "/profiel/telefoonnummer/{$encryptedId}";
        if (in_array($this->data['reference'], [Site::REF_CAR_DE, Site::REF_MOTO_DE])) {
            $endPoint = "/profil/telefonnummer/{$encryptedId}";
        }

        return sprintf('%s%s', rtrim($domain, '/'), $endPoint);
    }
}
