<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerData;
use DealerDirect\Generic\Category\EmailType;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class GoogleReviewInvite extends Mailer
{
    use ConsumerData;

    /** @var string */
    protected $emailType = EmailType::GOOGLE_REVIEW_INVITE;

    /**
     * @return void
     */
    public function __invoke(): void
    {
        $this->setData();

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
            Key::AGENT_WHATSAPP => $this->getGroupWhatsappByLotId(),
        ]);

        $this->send();
    }
}
