<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use DealerDirect\Generic\Category\Country;
use Dealerdirect\Emails\Traits\EncryptHash;
use Dealerdirect\Emails\Traits\ConsumerData;
use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Emails\Traits\ConsumerDomains;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class VehicleSelfSoldSurvey extends Mailer
{
    use ConsumerData;
    use ConsumerDomains;
    use EncryptHash;

    /** @var string */
    protected $emailType = EmailType::CONSUMER_SELF_SOLD;

    protected $query = [
        VehicleType::CAR => [
            'selects' => [
                'bl.voornaam AS agent_name',
            ],
            'leftJoin' => [
                ['v', 'dealer01_ddmain.agents_vehicles', 'av', 'v.id = av.lot_id'],
                ['av', 'dealer01_ddmain.backoffice_login', 'bl', 'av.user_id = bl.user_id'],
            ],
        ],
        VehicleType::MOTOR => [
            'selects' => [
                'bl.voornaam AS agent_name',
            ],
            'leftJoin' => [
                ['v', 'dealer01_ddmoto.agents_vehicles', 'av', 'v.id = av.lot_id'],
                ['av', 'dealer01_ddmain.backoffice_login', 'bl', 'av.user_id = bl.user_id'],
            ],
        ],
    ];

    /**
     * @param string $agentName
     * @return void
     */
    public function __invoke(int $countryId = Country::NETHERLANDS)
    {
        $this->countryId = $countryId;
        $this->setData();

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::LOT_NUMBER => $this->data['lot_id'],
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::AGENT_NAME => $this->getAgentName(),
            Key::URL => $this->getUrl(),
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
            Key::AGENT_WHATSAPP => $this->getGroupWhatsappByLotId(),
        ]);

        $this->send();
    }

    /**
     * @return string
     */
    private function getUrl(): string
    {
        $domain = $this->getDomainByReference((int) $this->data['reference']);
        $encryptedId = $this->encryptHash($this->data['lot_id']);
        $endpoint = "/service-survey/{$encryptedId}";

        return sprintf('%s%s', rtrim($domain, '/'), $endpoint);
    }
}
