<?php

namespace Dealerdirect\Emails\Traits;

use DealerDirect\Generic\Category\Country;
use Dealerdirect\Emails\Traits\ConsumerData;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * @property Connection $dbal
 */
trait ConsumerDeliveryData
{
    use ConsumerData {
        ConsumerData::carQuery as parentCarQuery;
        ConsumerData::motorQuery as parentMotorQuery;
    }

    /** @var integer */
    protected $countryId;

    /**
     * Gets delivery table for car
     *
     * @return string
     */
    private function getTable(): string
    {
        $countrySuffix = [Country::BELGIUM => '_be', Country::GERMANY => '_de'];

        return sprintf('verkopen_levering%s', $countrySuffix[$this->countryId] ?? '');
    }

    /**
     * @return QueryBuilder
     */
    protected function carQuery(): QueryBuilder
    {
        $queryBuilder = $this->parentCarQuery();
        $parentTable = $queryBuilder->getQueryPart('from')[0];
        $queryBuilder->resetQueryPart('from');
        $queryBuilder->resetQueryPart('where');

        return $queryBuilder
            ->addSelect([
                'vl.id as deliver_id',
                'vl.kavelref as lot_id',
                'ddb.bedrijfsnaam AS dealer_name',
                'ddb.plaats AS dealer_city',
                'vl.verkoper AS agent',
            ])
            ->from("dealer01_ddmain.{$this->getTable()}", 'vl')
            ->leftJoin('vl', $parentTable['table'], $parentTable['alias'], "vl.kavelref = {$parentTable['alias']}.id")
            ->leftJoin('vl', 'dealer01_ddmain.dealerdirect_bedr', 'ddb', 'vl.bedrijvenID = ddb.bedrijvenID')
            ->where('vl.id = :id');
    }

    /**
     * @return QueryBuilder
     */
    protected function motorQuery(): QueryBuilder
    {
        $queryBuilder = $this->parentCarQuery();
        $parentTable = $queryBuilder->getQueryPart('from')[0];
        $queryBuilder->resetQueryPart('from');
        $queryBuilder->resetQueryPart('where');

        return $queryBuilder
            ->addSelect([
                'vl.id as deliver_id',
                'vl.kavelref as lot_id',
                'ddb.bedrijfsnaam AS dealer_name',
                'ddb.plaats AS dealer_city',
                'vl.verkoper AS agent',
            ])
            ->from('dealer01_ddmoto.BO_Verkopen_NL', 'vl')
            ->leftJoin('vl', $parentTable['table'], $parentTable['alias'], "vl.kavelref = {$parentTable['alias']}.id")
            ->leftJoin('vl', 'dealer01_ddmain.dealerdirect_bedr', 'ddb', 'vl.bedrijvenID = ddb.bedrijvenID')
            ->where('vl.id = :id');
    }
}
