<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerData;
use Dealerdirect\Emails\Traits\ConsumerDomains;
use Dealerdirect\Emails\Traits\EncryptHash;
use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\Site;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class SendOfferManually extends Mailer
{
    use ConsumerData;
    use ConsumerDomains;
    use EncryptHash;

    protected $query = [
        VehicleType::MOTOR => [
            'selects' => [
                'highest_bid.com as commission',
                'highest_bid.bedrag as highest_bid',
            ],
            'leftJoin' => [
                ['v', 'highestBidJoin', 'highest_bid', 'highest_bid.voertuigID = v.id'],
            ],
        ],
        VehicleType::CAR => [
            'selects' => [
                'highest_bid.comm as commission',
                'highest_bid.bod as highest_bid',
            ],
            'table' => ['dealer01_ddmain.verzamel_base', 'v'],
            'innerJoin' => [],
            'leftJoin' => [
                ['v', 'highestBidJoin', 'highest_bid', "highest_bid.kavel = v.id"]
            ],
            'where' => ['v.id = :id'],
        ],
    ];

    /** @var string */
    protected $emailType = EmailType::BID_TO_CONSUMER;

    public function __invoke(string $agentName): void
    {
        $this->setData();

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::AGENT_NAME => $agentName,
            Key::LOT_NUMBER => $this->data['lot_id'],
            Key::VEHICLE_CONSUMER_PRICE => ($this->data['highest_bid'] - $this->data['commission']),
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
            Key::URL_UNSUBSCRIBE => $this->getUnsubscribeUrl(),
        ]);

        $this->send();
    }
}
