<?php

namespace Dealerdirect\Emails\Traits;

use Dealerdirect\Emails\Mailer;
use Doctrine\DBAL\Connection;
use DealerDirect\Generic\Category\VehicleType;

/**
 * @property Connection $dbal
 * @property string $vehicleType
 * @property array $data
 */
trait AanmeldData
{
    protected $mailDomain = Mailer::CONSUMER_MAIL;

    protected $defaultQuery = [
        VehicleType::CAR => [
            'selects' => [
                'v.id as lot_id',
                'v.reference',
                'v.land AS country_id',
                'v.aanhef AS salutation',
                'v.voorletters AS first_name',
                'v.naam AS last_name',
                'v.email',
                'v.telefoonnummer AS phone1',
                'v.gsmnummer AS phone2',
                'v.kenteken AS license_plate',
                'v.kmstand AS mileage',
                'v.extra_data',
                'makes.merkNaam AS make',
                'models.modelNaam AS model',
            ],
            'table' => ['dealer01_aanmelden.verzamel_iwvmaa', 'v'],
            'leftJoin' => [
                ['v', 'dealer01_webservices.SB_MERKEN', 'makes', 'v.automerk = makes.merkID'],
                ['v', 'dealer01_webservices.SB_MODELLEN', 'models', 'v.autotype = models.modelID'],
            ],
            'where' => ['v.id = :id'],
        ],
        VehicleType::MOTOR => [
            'selects' => [
                'v.id as lot_id',
                'v.reference',
                'v.aanhef AS salutation',
                'v.voorletter AS first_name',
                'v.naam AS last_name',
                'v.email',
                'v.telefoonnummer AS phone1',
                'v.gsmnummer AS phone2',
                'v.kenteken AS license_plate',
                'v.kmstand AS mileage',
                'v.extra_data',
                'makes.merkNaam AS make',
                'models.modelNaam AS model',
            ],
            'table' => ['dealer01_aanmelden.motorfietsen', 'v'],
            'leftJoin' => [
                ['v', 'dealer01_webservices.SB_MERKEN', 'makes', 'v.merk = makes.merkID'],
                ['v', 'dealer01_webservices.SB_MODELLEN', 'models', 'v.model = models.modelID'],
            ],
            'where' => ['v.id = :id'],
        ],
    ];
}
