<?php

namespace Dealerdirect\Emails\Dealer;

use Dealerdirect\Emails\Mailer;
use DealerDirect\Generic\Category\Locale;
use DealerDirect\Generic\Category\Country;
use Dealerdirect\Emails\Traits\DealerDomain;
use Dealerdirect\Emails\Traits\DeliveryTable;
use Dealerdirect\Emails\Traits\EncryptHash;
use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class WeMissYou extends Mailer
{
    use DealerDomain;

    private const ALLOWED_LOCALES = [Locale::NL_NL, Locale::NL_BE];

    protected $mailDomain = Mailer::DEALER_MAIL;

    protected $emailType = EmailType::DEALER_WE_MISS_YOU;

    protected $query = [
        VehicleType::CAR => [
            'selects' => [
                'ddb.bedrijfsnaam as company_name',
                'COALESCE(NULLIF(ddbe.akkoord_email, ""), NULLIF(ddbe.akkoord_email2, "")) AS email',
                'ddb.first_name',
                'ddb.last_name',
            ],
            'table' => ['dealer01_ddmain.dealerdirect_bedr', 'ddb'],
            'leftJoin' => [
                ['ddb', 'dealer01_ddmain.dealerdirect_bedr_email', 'ddbe', 'ddb.bedrijvenID = ddbe.bedrijvenID'],
            ],
            'where' => ['ddb.bedrijvenID = :id'],
        ],
    ];


    public function __invoke(int $countryId = Country::NETHERLANDS)
    {
        $this->countryId = $countryId;
        $this->setData();

        $this->substitutions = new Substitutions([
            Key::DEALER_NAME => $this->data['company_name'],
        ]);

        // Set vehicleType to car as this mail only exists for car, the content is ok for all vehicleTypes.
        $this->vehicleType = VehicleType::CAR;
        $this->setLocale();
        $this->send();
    }

    /**
     * Overwrites locale if locale is BE, as this mail only exists for NL
     *
     * @return void
     */
    private function setLocale()
    {
        if (!in_array($this->locale, self::ALLOWED_LOCALES, true)) {
            $allowed = implode(', ', self::ALLOWED_LOCALES);

            throw new \Exception("Error, locale '{$this->locale}' is not supported. Allowed locales: '$allowed'");
        }

        if ($this->locale === Locale::NL_BE) {
            $this->locale = Locale::NL_NL;
        }
    }
}
