<?php

namespace Dealerdirect\Emails;

use Doctrine\DBAL\Connection;
use DealerDirect\Generic\Category\VehicleType;

class Helper
{
    private $dbal;
    private $vehicleType;

    public function __construct(Connection $dbal, string $vehicleType)
    {
        $this->dbal = $dbal;
        $this->vehicleType = $vehicleType;
    }

    public function highestBidJoin()
    {
        list($table, $lotColumn, $bidColumn) = $this->vehicleType === VehicleType::MOTOR
            ? ['dealer01_ddmoto.BO_Biedhistorie', 'voertuigID', 'bedrag']
            : ['dealer01_ddmain.biedingen_base', 'kavel', 'bod'];

        return $this->genericHighestJoin($table, <<<SQL
                t1.$lotColumn = t2.$lotColumn
                AND t1.status = t2.status
                AND t1.$bidColumn < t2.$bidColumn
            SQL)
            ->where("t2.$lotColumn IS NULL")
            ->andWhere('t1.status = "active"');
    }

    public function internalPriceJoin()
    {
        return $this->genericHighestJoin('dealer01_ddmain.vehicle_value', <<<SQL
            t1.vehicle_id = t2.vehicle_id
            AND t1.vehicle_value_source_id = t2.vehicle_value_source_id
            AND t1.id < t2.id
            SQL
        )
        ->where('t2.value IS NULL')
        ->where('t1.vehicle_value_source_id = 1');
    }

    private function genericHighestJoin($table, $joinConditions)
    {
        return $this->dbal->createQueryBuilder()
            ->select('t1.*')
            ->from($table, 't1')
            ->leftJoin('t1', $table, 't2', $joinConditions);
    }
}
