<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerData;
use Dealerdirect\Emails\Traits\ConsumerDomains;
use Dealerdirect\Emails\Traits\EncryptHash;
use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\Site;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;
use Dealerdirect\Sdk\Model\Email\Substitutions;

class RequestPhone extends Mailer
{
    use ConsumerData;
    use EncryptHash;
    use ConsumerDomains;

    /** @var string */
    protected $emailType = EmailType::REQUEST_PHONE;

    protected $query = [
        VehicleType::CAR => [
            'selects' => [
                'bl.voornaam AS agent_name',
            ],
            'leftJoin' => [
                ['v', 'dealer01_ddmain.agents_vehicles', 'av', 'v.id = av.lot_id'],
                ['av', 'dealer01_ddmain.backoffice_login', 'bl', 'av.user_id = bl.user_id'],
            ],
        ],
        VehicleType::MOTOR => [
            'selects' => [
                'bl.voornaam AS agent_name',
            ],
            'leftJoin' => [
                ['v', 'dealer01_ddmoto.agents_vehicles', 'av', 'v.id = av.lot_id'],
                ['av', 'dealer01_ddmain.backoffice_login', 'bl', 'av.user_id = bl.user_id'],
            ],
        ],
    ];

    public function __invoke(): void
    {
        $this->setData();

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::LOT_NUMBER => $this->id,
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::URL => $this->getUrl(),
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
            Key::AGENT_NAME => $this->getAgentName(),
        ]);

        $this->send();
    }

    private function getUrl()
    {
        $reference = (int) $this->data['reference'];
        $domain = $this->getDomainByReference($reference);
        $encryptedId = $this->encryptHash($this->id);
        $endPoint = "/profiel/telefoonnummer/{$encryptedId}";
        if (in_array($reference, [Site::REF_CAR_DE, Site::REF_MOTO_DE])) {
            $endPoint = "/profil/telefonnummer/{$encryptedId}";
        } elseif ($reference === Site::REF_CAR_MARKTPLAATS_NL) {
            $endPoint = "/#/telefoon-aanpassen?token={$encryptedId}";
        }

        return sprintf('%s%s', rtrim($domain, '/'), $endPoint);
    }
}
