<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerBidData;
use DealerDirect\Generic\Category\EmailType;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class SendOfferManually extends Mailer
{
    use ConsumerBidData;

    /** @var string */
    protected $emailType = EmailType::BID_TO_CONSUMER;

    public function __invoke(string $agentName): void
    {
        $this->setData();
        $this->addRecipient("{$this->data['first_name']} {$this->data['last_name']}", $this->data['email']);

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::AGENT_NAME => $agentName,
            Key::LOT_NUMBER => $this->data['id'],
            Key::VEHICLE_CONSUMER_PRICE => ($this->data['highest_bid'] - $this->data['commission']),
        ]);

        $this->send();
    }
}
