<?php

require_once dirname(__DIR__) . '/vendor/autoload.php';

use Dealerdirect\Emails\Consumer\AgentRatingSurvey;
use Dealerdirect\Emails\Consumer\DealerRatingSurvey;
use Dealerdirect\Emails\Consumer\DeliveryHandling;
use Dealerdirect\Emails\Consumer\HighestBid;
use Dealerdirect\Emails\Consumer\Nurture;
use Dealerdirect\Emails\Consumer\RequestContact;
use Dealerdirect\Emails\Consumer\RequestPhone;
use Dealerdirect\Emails\Consumer\SendOfferManually;
use Dealerdirect\Emails\Consumer\SendTrainTicket;
use Dealerdirect\Emails\Dealer\DeliveryStatusRequest;
use DealerDirect\Generic\Category\Country;
use DealerDirect\Generic\Category\LeadNurtureStatus;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Sdk\Config;
use DealerDirect\Sdk\Sdk;
use Doctrine\DBAL\DriverManager;

$binaryKey = 'EmsbBUFwIbL2Sq2vBj519AyE8Gazb2Z6nUOPHPQPnX4';
$sdk = new Sdk(new Config([Config::EMAIL_SERVICE_URL => 'https://email-service.email-service.test/api/v1']));
$client = $sdk->getEmail();
$dbal = DriverManager::getConnection(
    [
       'dbname' => 'dealer01_ddmain',
       'user' => 'vagrant',
       'password' => 'vagrant',
       'host' => 'aio.test',
       'driver' => 'pdo_mysql',
    ],
    new \Doctrine\DBAL\Configuration()
);

$domains = [
    'carNl' => '//ikwilvanmijnautoaf.nl.aio.test',
    'carBe' => '//ikwilvanmijnautoaf.be.aio.test',
    'carDe' => '//ichwillmeinautoloswerden.de.aio.test',
    'motorNl' => '//ikwilvanmijnmotorfietsaf.nl.aio.test',
    'motorBe' => '//ikwilvanmijnmotoraf.be.aio.test',
    'motorDe' => '//ichwillmeinmotorradloswerden.de.aio.test',
    'scooterNl' => '//ikwilvanmijnscooteraf.nl.aio.test',
];

$lotId = $dbal->fetchOne(<<<SQL
SELECT id
FROM dealer01_ddmain.verzamel_base
ORDER BY id DESC
LIMIT 1
SQL);

$dealerDeliverId = $dbal->fetchOne(<<<SQL
SELECT id
FROM verkopen_levering
WHERE delivered_consumer IS NOT NULL
ORDER BY id DESC
LIMIT 1
SQL);

$deliveredId = $dbal->fetchOne(<<<SQL
SELECT id
FROM verkopen_levering
WHERE delivered = 'delivered'
ORDER BY id DESC
LIMIT 1
SQL);

// Dealer rating survey
$survey = new DealerRatingSurvey($client, $dbal, VehicleType::CAR, $deliveredId);
$survey->setDomains($domains);
$survey->setBinaryKey($binaryKey);
$survey();

// Dealer DeliveryStatusRequest
$email = new DeliveryStatusRequest($sdk->getEmail(), $dbal, VehicleType::CAR, $dealerDeliverId);
$email->setDomain('//dealerdirect.eu.aio.test');
$email->setBinaryKey($binaryKey);
$email(1);

$motorDealerDeliverId = $dbal->fetchOne(<<<SQL
SELECT vl.id
FROM dealer01_ddmoto.BO_Verkopen_NL vl
    LEFT JOIN dealer01_ddmoto.BO_Verkopen_NL_annreden vla
        ON vla.leverid = vl.id
WHERE vl.delivered_consumer IS NULL
    AND vl.delivered = 'not-delivered'
    AND vla.leverid IS NULL
ORDER BY vl.id DESC
LIMIT 1
SQL);

// Dealer DeliveryStatusRequest
$email = new DeliveryStatusRequest($sdk->getEmail(), $dbal, VehicleType::MOTOR, $motorDealerDeliverId);
$email->setDomain('//dealerdirect.eu.aio.test');
$email->setBinaryKey($binaryKey);
$email();

$vehicleValueJoin = <<<SQL
SELECT
    v1.*
FROM
    dealer01_ddmain.vehicle_value as v1
    LEFT JOIN
        dealer01_ddmain.vehicle_value as v2
        ON v1.vehicle_id = v2.vehicle_id
        AND v1.vehicle_value_source_id = v2.vehicle_value_source_id
        AND v1.id < v2.id
WHERE
    v2.value is NULL AND
    v1.vehicle_value_source_id = 1
SQL;

$highestBidIds = [
    'highest-bid-offending' => <<<SQL
    SELECT vb.id
    FROM dealer01_ddmain.verzamel_base vb
        LEFT JOIN ({$vehicleValueJoin}) as internal_price
            ON internal_price.vehicle_id = vb.id
    WHERE internal_price.value IS NULL
        OR internal_price.value = 0
    ORDER BY vb.id DESC
    LIMIT 1
    SQL,
    'highest-bid' => <<<SQL
    SELECT vb.id
    FROM dealer01_ddmain.verzamel_base vb
        LEFT JOIN (
            SELECT t1.*
            FROM dealer01_ddmain.biedingen_base AS t1
                LEFT JOIN dealer01_ddmain.biedingen_base AS t2
                    ON t1.kavel = t2.kavel
                    AND t1.status = 'active'
                    AND t2.status = 'active'
                    AND t1.bod < t2.bod
            WHERE t2.kavel IS NULL
                AND t1.status = 'active'
        ) as highest_bid
            ON highest_bid.kavel = vb.id
        LEFT JOIN ({$vehicleValueJoin}) as internal_price
            ON internal_price.vehicle_id = vb.id
    WHERE vb.status = 1
        AND internal_price.value IS NOT NULL
        AND internal_price.value < (highest_bid.bod - highest_bid.comm)
    ORDER BY vb.id DESC
    LIMIT 1
    SQL
];
// Highest bid
foreach ($highestBidIds as $type => $query) {
    $highestBidId = $dbal->fetchOne($query);
    if (empty($highestBidId)) {
        echo "[$type] failed to fetch id.";
        continue;
    }
    $email = new HighestBid($sdk->getEmail(), $dbal, VehicleType::CAR, $highestBidId);
    $email->setDomains($domains);
    $email();
}

// Send Nurture mail
// 8579092 = Empty internal_price and should throw EmptyInternalPriceException
$nurtureStatuses = [
    LeadNurtureStatus::NURTURE_CURIOUS,
    LeadNurtureStatus::NURTURE_VALUATION,
    LeadNurtureStatus::NURTURE_MORE_TIME,
    LeadNurtureStatus::NURTURE_ASKING_PRICE
];
$nurtureQuery = <<<SQL
SELECT id
FROM dealer01_ddmain.verzamel_base
WHERE lead_nurture_status = :nurture
    AND status = 1
ORDER BY id DESC
LIMIT 1
SQL;
foreach ($nurtureStatuses as $nurture) {
    $nurtureLotId = $dbal->fetchOne($nurtureQuery, compact('nurture'));
    if (empty($nurtureLotId)) {
        echo "[nurture][$nurture] failed to fetch id.";
        continue;
    }
    $email = new Nurture($sdk->getEmail(), $dbal, VehicleType::CAR, $nurtureLotId);
    $email->setDomains($domains);
    $email->setBinaryKey('XssklYs3nfo+DRftgT8tWgdzoU1oe9Llg8JOvp4Aogg=');
    $email();
}

// Send RequestContact
$email = new RequestContact($sdk->getEmail(), $dbal, VehicleType::CAR, $lotId);
$email('Agent Name');

// Send RequestPhone
$email = new RequestPhone($sdk->getEmail(), $dbal, VehicleType::CAR, $lotId);
$email->setDomains($domains);
$email->setBinaryKey($binaryKey);
$email();

// Send offer manually
$email = new SendOfferManually($client, $dbal, VehicleType::CAR, $lotId);
$email('Agent Name');

// Send Train ticket
$email = new SendTrainTicket($client, $dbal, VehicleType::CAR, $lotId);
$email('Agent Name');

// Delivery Handling
$deliverId = $dbal->fetchOne(<<<SQL
SELECT id
FROM verkopen_levering
WHERE geleverd = 0
    AND geleverd_dd = 0
    AND geleverd_bedr = 0
ORDER BY id DESC
LIMIT 1
SQL);

$followUps = [DeliveryHandling::MANUALLY, DeliveryHandling::FIRST_FOLLOW_UP, DeliveryHandling::SECOND_FOLLOW_UP];
foreach ($followUps as $followUp) {
    $email = new DeliveryHandling($client, $dbal, VehicleType::CAR, $deliverId);
    $email->setDomains($domains);
    $email->setBinaryKey($binaryKey);
    $email(Country::NETHERLANDS, $followUp);
}

// Agent Rating Survey
$lotId = $dbal->fetchOne(<<<SQL
SELECT id
FROM dealer01_ddmain.verzamel_base
WHERE vehicle_processed = 1
ORDER BY id DESC
LIMIT 1
SQL);

$agent = new AgentRatingSurvey($client, $dbal, VehicleType::CAR, $lotId);
$agent->setDomains($domains);
$agent->setBinaryKey($binaryKey);
$agent();
