<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerData;
use Dealerdirect\Emails\Traits\ConsumerDomains;
use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class ReRequestContact extends Mailer
{
    use ConsumerData;
    use ConsumerDomains;

    /** @var string */
    protected $emailType = EmailType::CONSUMER_RE_REQUEST_CONTACT;

    protected $query = [
        VehicleType::CAR => [
            'selects' => ['bl.voornaam AS agent_name'],
            'leftJoin' => [
                ['v', 'dealer01_ddmain.backoffice_login', 'bl', 'bl.user_id = :agentId'],
            ]
        ],
        VehicleType::MOTOR => [
            'selects' => ['bl.voornaam AS agent_name'],
            'leftJoin' => [
                ['v', 'dealer01_ddmain.backoffice_login', 'bl', 'bl.user_id = :agentId'],
            ]
        ],
    ];

    /**
     * @param string $agentName
     * @return void
     */
    public function __invoke(int $agentId): void
    {
        $this->setData([
            'id' => $this->id,
            'agentId' => $agentId,
        ]);

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
            Key::AGENT_NAME => $this->getAgentName(),
            Key::LOT_NUMBER => $this->data['lot_id'],
            Key::CUSTOMER_SERVICE_PHONE => $this->getCustomerServicePhone(),
        ]);

        $this->send();
    }

    private function getAgentName()
    {
        $agentName = $this->data['agent_name'];
        if (empty($agentName) || $agentName === 'No user') {
            $agentName = $this->getNameByReference((int) $this->data['reference']);
        }

        return $agentName;
    }
}
