<?php

namespace Dealerdirect\Emails\Traits;

trait DealerDomain
{
    /** @var array */
    protected $domains;

    /**
     * Sets consumer domains
     *
     * @param string $domains
     * @return void
     */
    public function setDomain(string $domain)
    {
        $this->domain = $domain;
    }

    /**
     * Gets dealer domain with language suffix
     *
     * @return string
     */
    protected function getDomain($withLanguage = true): string
    {
        $language = $this->data['language'] ?? ($this->data['dealer_country'] ?? '');

        return rtrim(
            sprintf(
                '%s/%s',
                rtrim($this->domain, '/'),
                $withLanguage ? strtolower($language === 'BE' ? 'nl-be' : $language) : ''
            ),
            '/'
        );
    }
}
