<?php

namespace Dealerdirect\Emails\Traits;

use ParagonIE\Paseto\Protocol\Version2;
use ParagonIE\Paseto\Keys\Version2\SymmetricKey;

trait EncryptHash
{
    protected $binaryKey;

    public function setBinaryKey(string $key)
    {
        $this->binaryKey = $key;
    }

    protected function encryptHash(string $toEncrypt)
    {
        if (empty($this->binaryKey)) {
            throw new \Exception("Error, no binaryKey set. Set it by method 'setBinaryKey(\$key)'.");
        }
        $sharedKey = new SymmetricKey(base64_decode($this->binaryKey));

        return !empty($toEncrypt)
            ? Version2::encrypt($toEncrypt, $sharedKey)
            : null;
    }
}
