<?php

namespace Dealerdirect\Emails\Traits;

use Dealerdirect\Emails\Mailer;
use Doctrine\DBAL\Connection;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Repository\CallGroupInformation;

/**
 * @property Connection $dbal
 * @property string $vehicleType
 * @property array $data
 *
 * @method string formatPhone()
 */
trait ConsumerData
{
    protected $mailDomain = Mailer::CONSUMER_MAIL;

    protected $defaultQuery = [
        VehicleType::CAR => [
            'selects' => [
                'v.id as lot_id',
                'v.reference',
                'v.land AS country_id',
                'v.aanhef AS salutation',
                'v.voorletters AS first_name',
                'v.naam AS last_name',
                'v.email',
                'v.telefoonnummer AS phone1',
                'v.gsmnummer AS phone2',
                'makes.merkNaam AS make',
                'models.modelNaam AS model',
            ],
            'table' => ['dealer01_ddmain.verzamel_base', 'v'],
            'leftJoin' => [
                ['v', 'dealer01_webservices.SB_MERKEN', 'makes', 'v.automerk = makes.merkID'],
                ['v', 'dealer01_webservices.SB_MODELLEN', 'models', 'v.autotype = models.modelID'],
            ],
            'where' => ['v.id = :id'],
        ],
        VehicleType::MOTOR => [
            'selects' => [
                'v.id as lot_id',
                'v.reference',
                'p.country_id',
                'p.aanhef AS salutation',
                'p.voornaam AS first_name',
                'p.achternaam AS last_name',
                'p.email',
                'p.telefoon1 AS phone1',
                'p.telefoon2 AS phone2',
                'makes.merkNaam AS make',
                'models.modelNaam AS model',
            ],
            'table' => ['dealer01_ddmoto.BO_Motorfiets', 'v'],
            'innerJoin' => [
                ['v', 'dealer01_ddmoto.BO_Persoon', 'p', 'v.PersoonID = p.PersoonID'],
            ],
            'leftJoin' => [
                ['v', 'dealer01_webservices.SB_MERKEN', 'makes', 'v.merk = makes.merkID'],
                ['v', 'dealer01_webservices.SB_MODELLEN', 'models', 'v.model = models.modelID'],
            ],
            'where' => ['v.id = :id'],
        ],
    ];

    /**
     * @return string
     */
    protected function getGroupPhoneByLotId()
    {
        $callGroup = new CallGroupInformation($this->dbal, $this->vehicleType);

        return $this->formatPhone($callGroup->getCurrentCallGroupPhoneNumber($this->data['lot_id']));
    }

    protected function getAgentName()
    {
        $agentName = $this->data['agent_name'] ?? null;
        if (empty($agentName) || $agentName === 'No user') {
            $agentName = $this->getNameByReference((int) $this->data['reference']);
        }

        return $agentName;
    }
}
