<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerData;
use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\Site;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class TrustpilotReviewInvite extends Mailer
{
    use ConsumerData;

    private const TRUSTPILOT_EMAILS = [
        Site::REF_CAR_NL => 'www.ikwilvanmijnautoaf.nl+76022ba4a0@invite.trustpilot.com',
        Site::REF_CAR_BE_NL => 'ikwilvanmijnautoaf.be+29c78bda82@invite.trustpilot.com',
        Site::REF_MOTO_NL => 'ikwilvanmijnmotorfietsaf.nl+f9e7e80c0d@invite.trustpilot.com',
        Site::REF_MOTO_BE => 'ikwilvanmijnmotoraf.be+0cffdc63cd@invite.trustpilot.com',
        Site::REF_MOTO_DE => 'ichwillmeinmotorradloswerden.de+3e83a276a3@invite.trustpilot.com',
        Site::REF_SCOOTER_NL => 'ikwilvanmijnscooteraf.nl+445a6aa701@invite.trustpilot.com',
    ];

    /** @var string */
    protected $emailType = EmailType::TRUSTPILOT_INVITE;

    /**
     * @return void
     */
    public function __invoke(): void
    {
        $this->setData();

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::LOT_NUMBER => $this->data['lot_id'],
            Key::CONSUMER_EMAIL => $this->data['email'],
            Key::LOT_NUMBER => $this->data['lot_id'],
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
        ]);

        $bccEmail = self::TRUSTPILOT_EMAILS[$this->data['reference']] ?? '';

        $this->addRecipient('Trustpilot', $bccEmail, 'bcc');
        $this->send();
    }
}
