<?php

namespace Dealerdirect\Emails\Traits;

use DealerDirect\Generic\Category\Language;

trait DealerDomain
{
    /** @var array */
    protected $domains;

    /**
     * Sets consumer domains
     *
     * @param string $domains
     * @return void
     */
    public function setDomain(string $domain)
    {
        $this->domain = $domain;
    }

    /**
     * Gets dealer domain with language suffix
     *
     * @return string
     */
    protected function getDomain($withLanguage = true): string
    {
        $language = strtolower($this->data['dealer_country'] ?? '');
        if (!empty($this->data['language_id'])) {
            $language = $this->helper->getDealerPrimaryLanguages((int) $this->data['language_id']);
        }

        return rtrim(
            sprintf(
                '%s/%s',
                rtrim($this->domain, '/'),
                $withLanguage ? strtolower($language === Language::BE ? 'nl-be' : $language) : ''
            ),
            '/'
        );
    }
}
