<?php

require_once dirname(__DIR__) . '/vendor/autoload.php';

use Dealerdirect\Emails\Consumer\DeliveryHandling;
use Dealerdirect\Emails\Consumer\HighestBid;
use Dealerdirect\Emails\Consumer\Nurture;
use Dealerdirect\Emails\Consumer\RequestContact;
use DealerDirect\Sdk\Sdk;
use DealerDirect\Sdk\Config;
use Doctrine\DBAL\DriverManager;
use Dealerdirect\Emails\Consumer\RequestPhone;
use Dealerdirect\Emails\Consumer\SendOfferManually;
use Dealerdirect\Emails\Consumer\SendTrainTicket;
use Dealerdirect\Emails\Exceptions\EmptyInternalPriceException;
use DealerDirect\Generic\Category\VehicleType;

$lotId = 8432222;
$deliverId = 757363;
$binaryKey = 'EmsbBUFwIbL2Sq2vBj519AyE8Gazb2Z6nUOPHPQPnX4';
$sdk = new Sdk(new Config([Config::EMAIL_SERVICE_URL => 'https://email-service.email-service.test/api/v1']));
$client = $sdk->getEmail();

$dbal = DriverManager::getConnection(
    [
       'dbname' => 'dealer01_ddmain',
       'user' => 'vagrant',
       'password' => 'vagrant',
       'host' => 'aio.test',
       'driver' => 'pdo_mysql',
    ],
    new \Doctrine\DBAL\Configuration()
);

$domains = [
    'carNl' => '//ikwilvanmijnautoaf.nl.aio.test',
    'carBe' => '//ikwilvanmijnautoaf.be.aio.test',
    'carDe' => '//ichwillmeinautoloswerden.de.aio.test',
    'motorNl' => '//ikwilvanmijnmotorfietsaf.nl.aio.test',
    'motorBe' => '//ikwilvanmijnmotoraf.be.aio.test',
    'motorDe' => '//ichwillmeinmotorradloswerden.de.aio.test',
    'scooterNl' => '//ikwilvanmijnscooteraf.nl.aio.test',
];

// Highest bid
$email = new HighestBid($sdk->getEmail(), $dbal, VehicleType::CAR, $lotId);
$email->setDomains($domains);
$email();

// Send Nurture mail
// 8579092 = Empty internal_price and should throw EmptyInternalPriceException
foreach ([8593182, 8590252, 8592382, 8593392, 8579092] as $id) {
    try {
        $email = new Nurture($sdk->getEmail(), $dbal, VehicleType::CAR, $id);
        $email->setDomains($domains);
        $email->setBinaryKey('XssklYs3nfo+DRftgT8tWgdzoU1oe9Llg8JOvp4Aogg=');
        $email();
    } catch (EmptyInternalPriceException $exception) {
        echo sprintf("[%s] %s\n", $id, $exception->getMessage());
    }
}

// Send RequestContact
$email = new RequestContact($sdk->getEmail(), $dbal, VehicleType::CAR, $lotId);
$email('Agent Name');

// Send RequestPhone
$email = new RequestPhone($sdk->getEmail(), $dbal, VehicleType::CAR, $lotId);
$email->setDomains($domains);
$email->setBinaryKey($binaryKey);
$email();

// Send offer manually
$email = new SendOfferManually($client, $dbal, VehicleType::CAR, $lotId);
$email('Agent Name');

// Send Train ticket
$email = new SendTrainTicket($client, $dbal, VehicleType::CAR, $lotId);
$email('Agent Name');

// Delivery Handling
$email = new DeliveryHandling($client, $dbal, VehicleType::CAR, $deliverId);
$email->setDomains($domains);
$email->setBinaryKey($binaryKey);
$email();
