<?php

namespace Dealerdirect\Emails\Traits;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use DealerDirect\Generic\Repository\CallGroupInformation;

/**
 * @property Connection $dbal
 * @property string $vehicleType
 * @property array $data
 *
 * @method string formatPhone()
 */
trait ConsumerData
{
    /**
     * @return void
     */
    protected function getGroupPhoneByLotId()
    {
        $callGroup = new CallGroupInformation($this->dbal, $this->vehicleType);

        return $this->formatPhone($callGroup->getCurrentCallGroupPhoneNumber($this->data['id']));
    }

    /**
     * @return QueryBuilder
     */
    protected function carQuery(): QueryBuilder
    {
        return $this->dbal->createQueryBuilder()
            ->select([
                'v.id',
                'v.reference',
                'v.land AS country_id',
                'v.voorletters AS first_name',
                'v.naam AS last_name',
                'v.email',
                'v.telefoonnummer AS phone1',
                'v.gsmnummer AS phone2',
                'makes.merkNaam AS make',
                'models.modelNaam AS model',
            ])
            ->from('dealer01_ddmain.verzamel_base', 'v')
            ->leftJoin('v', 'dealer01_webservices.SB_MERKEN', 'makes', 'v.automerk = makes.merkID')
            ->leftJoin('v', 'dealer01_webservices.SB_MODELLEN', 'models', 'v.autotype = models.modelID')
            ->where('v.id = :id');
    }

    /**
     * @return QueryBuilder
     */
    protected function motorQuery(): QueryBuilder
    {
        return $this->dbal->createQueryBuilder()
            ->select([
                'v.id',
                'v.reference',
                'p.country_id',
                'p.voornaam AS first_name',
                'p.achternaam AS last_name',
                'p.email',
                'p.telefoon1 AS phone1',
                'p.telefoon2 AS phone2',
                'makes.merkNaam AS make',
                'models.modelNaam AS model',
            ])
            ->from('dealer01_ddmoto.BO_Motorfiets', 'v')
            ->innerJoin('v', 'dealer01_ddmoto.BO_Persoon', 'p', 'v.PersoonID = p.PersoonID')
            ->leftJoin('v', 'dealer01_webservices.SB_MERKEN', 'makes', 'v.merk = makes.merkID')
            ->leftJoin('v', 'dealer01_webservices.SB_MODELLEN', 'models', 'v.model = models.modelID')
            ->where('v.id = :id');
    }
}
