<?php

namespace Dealerdirect\Emails\Traits;

use DealerDirect\Generic\Category\Country;
use DealerDirect\Generic\Category\VehicleType;

trait DeliveryTable
{
    /**
     * Overwrites table for given countryId
     * Call before $this->setData()
     *
     * @return void
     */
    protected function setTable()
    {
        $countrySuffix = [Country::BELGIUM => '_be', Country::GERMANY => '_de'];
        if (in_array($this->countryId, array_keys($countrySuffix))) {
            // Only for car
            $this->query[VehicleType::CAR]['table'][0] = sprintf(
                'dealer01_ddmain.verkopen_levering%s',
                $countrySuffix[$this->countryId] ?? ''
            );
        }

        $baseVehicleType = $this->isMotor ? VehicleType::MOTOR : VehicleType::CAR;
        unset($this->defaultQuery[$baseVehicleType]['where']);
    }
}
