<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerData;
use Dealerdirect\Emails\Traits\ConsumerDomains;
use Dealerdirect\Emails\Traits\EncryptHash;
use DealerDirect\Generic\Category\Country;
use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\Site;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;
use Dealerdirect\Sdk\Model\Email\Substitutions;

class AgentRatingSurvey extends Mailer
{
    use ConsumerData;
    use ConsumerDomains;
    use EncryptHash;

    /** @var string */
    protected $emailType = EmailType::AGENT_RATING_SURVEY;

    protected $query = [
        VehicleType::CAR => [
            'selects' => [
                'bl.voornaam AS agent_name',
            ],
            'leftJoin' => [
                ['v', 'dealer01_ddmain.agents_vehicles', 'av', 'v.id = av.lot_id'],
                ['av', 'dealer01_ddmain.backoffice_login', 'bl', 'av.user_id = bl.user_id'],
            ],
        ],
        VehicleType::MOTOR => [
            'selects' => [
                'bl.voornaam AS agent_name',
            ],
            'leftJoin' => [
                ['v', 'dealer01_ddmoto.agents_vehicles', 'av', 'v.id = av.lot_id'],
                ['av', 'dealer01_ddmain.backoffice_login', 'bl', 'av.user_id = bl.user_id'],
            ],
        ],
    ];

    /**
     * @param string $agentName
     * @return void
     */
    public function __invoke(int $countryId = Country::NETHERLANDS)
    {
        $this->countryId = $countryId;
        $this->setData();

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::AGENT_NAME => $this->getAgentName(),
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
            Key::URL => $this->getUrl(),
        ]);

        $this->send();
    }

    /**
     * @return string
     */
    private function getUrl(): string
    {
        $reference = (int) $this->data['reference'];
        $encryptedId = $this->encryptHash($this->data['lot_id']);

        return sprintf(
            '%s/%s',
            rtrim($this->getDomainByReference($reference), '/'),
            $reference === Site::REF_CAR_MARKTPLAATS_NL
                ? "beoordeling?token=$encryptedId"
                : "agent-rating/$encryptedId",
        );
    }
}
