<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerData;
use Dealerdirect\Emails\Traits\ConsumerDomains;
use DealerDirect\Generic\Category\EmailType;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class RequestContact extends Mailer
{
    use ConsumerData;
    use ConsumerDomains;

    public const MANUALLY = 0;
    public const FIRST_FOLLOW_UP = 1;
    public const SECOND_FOLLOW_UP = 2;

    /** @var string */
    protected $emailType;

    protected $query = [
        VehicleType::CAR => [
            'selects' => ['bl.voornaam AS agent_name'],
            'leftJoin' => [
                ['v', 'dealer01_ddmain.backoffice_login', 'bl', 'bl.user_id = :agentId'],
            ]
        ],
        VehicleType::MOTOR => [
            'selects' => ['bl.voornaam AS agent_name'],
            'leftJoin' => [
                ['v', 'dealer01_ddmain.backoffice_login', 'bl', 'bl.user_id = :agentId'],
            ]
        ],
    ];

    /**
     * @param string $agentName
     * @return void
     */
    public function __invoke(int $agentId, int $followUp = self::MANUALLY): void
    {
        $this->setData([
            'id' => $this->id,
            'agentId' => $agentId,
        ]);
        $this->setEmailType($followUp);

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
            Key::AGENT_NAME => $this->getAgentName(),
            Key::LOT_NUMBER => $this->data['lot_id'],
            Key::CUSTOMER_SERVICE_PHONE => $this->getCustomerServicePhone(),
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
        ]);

        $this->send();
    }

    private function getAgentName()
    {
        $agentName = $this->data['agent_name'];
        if (empty($agentName) || $agentName === 'No user') {
            $agentName = $this->getNameByReference((int) $this->data['reference']);
        }

        return $agentName;
    }

    /**
     * @param integer $followUp
     * @return string
     */
    private function setEmailType(int $followUp): void
    {
        $types = [
            self::FIRST_FOLLOW_UP => EmailType::CONSUMER_REQUEST_CONTACT_FOLLOW_UP_FIRST,
            self::SECOND_FOLLOW_UP => EmailType::CONSUMER_REQUEST_CONTACT_FOLLOW_UP_SECOND,
        ];

        $this->emailType = $types[$followUp] ?? EmailType::CONSUMER_REQUEST_CONTACT;
    }
}
