<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\AanmeldData;
use Dealerdirect\Emails\Traits\ConsumerDomains;
use Dealerdirect\Emails\Traits\EncryptHash;
use DealerDirect\Generic\Category\Country;
use DealerDirect\Generic\Category\EmailType;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;
use Dealerdirect\Sdk\Model\Email\Substitutions;

class ValuationRegistrationNoPricingData extends Mailer
{
    use AanmeldData;
    use ConsumerDomains;
    use EncryptHash;

    /** @var string */
    protected $emailType = EmailType::CONSUMER_VALUATION_FLOW_REGISTRATION_NO_PRICING_DATA;

    /** @var int */
    protected $countryId;

    /** @var array */
    protected $data;

    /** @var Substitutions */
    protected $substitutions;

    /**
     * @param string $agentName
     * @return void
     */
    public function __invoke(int $countryId = Country::NETHERLANDS)
    {
        $this->countryId = $countryId;
        $this->setData();

        $mileage = number_format($this->data['mileage'], 0, ",", ".");

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::VEHICLE_REGISTRATION_PLATE => strtoupper($this->data['license_plate']),
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::VEHICLE_MILEAGE => $mileage,
            Key::URL_UNSUBSCRIBE => $this->getUnsubscribeUrl(),
        ]);

        $this->send();
    }
}
