<?php

namespace Dealerdirect\Emails;

use DealerDirect\Generic\Category\Language;
use DealerDirect\Generic\Category\Locale;
use DealerDirect\Generic\Category\VehicleType;
use Doctrine\DBAL\Connection;

class Helper
{
    private $dbal;
    private $vehicleType;

    public function __construct(Connection $dbal, string $vehicleType)
    {
        $this->dbal = $dbal;
        $this->vehicleType = $vehicleType;
    }

    public function highestBidJoin()
    {
        list($table, $lotColumn, $bidColumn) = $this->vehicleType === VehicleType::MOTOR
            ? ['dealer01_ddmoto.BO_Biedhistorie', 'voertuigID', 'bedrag']
            : ['dealer01_ddmain.biedingen_base', 'kavel', 'bod'];

        return $this->genericHighestJoin($table, <<<SQL
                t1.$lotColumn = t2.$lotColumn
                AND t1.status = t2.status
                AND t1.$bidColumn < t2.$bidColumn
            SQL)
            ->where("t2.$lotColumn IS NULL")
            ->andWhere('t1.status = "active"');
    }

    public function internalPriceJoin()
    {
        return $this->genericHighestJoin('dealer01_ddmain.vehicle_value', <<<SQL
            t1.vehicle_id = t2.vehicle_id
            AND t1.vehicle_value_source_id = t2.vehicle_value_source_id
            AND t1.id < t2.id
            SQL
        )
        ->where('t2.value IS NULL')
        ->andWhere('t1.vehicle_value_source_id = 1');
    }

    private function genericHighestJoin($table, $joinConditions)
    {
        return $this->dbal->createQueryBuilder()
            ->select('t1.*')
            ->from($table, 't1')
            ->leftJoin('t1', $table, 't2', $joinConditions);
    }

    public function getDealerPrimaryLanguages(int $languageId = null)
    {
        // Note: Same as Backoffice as thats the only place where it is editable
        //       The tables 'languages' and `countries` don't match with the languages we have
        $primaryLanguages =  [
            1 => Language::NL,
            2 => Language::BE,
            3 => Language::DE,
            4 => Language::FR,
            5 => Language::EN,
        ];

        return $languageId !== null
            ? ($primaryLanguages[$languageId] ?? null)
            : $primaryLanguages;
    }

    public function getLocaleByDealerLanguage(string $language)
    {
        $locales = [
            Language::NL => Locale::NL_NL,
            Language::BE => Locale::NL_BE,
            Language::DE => Locale::DE_DE,
            Language::FR => Locale::FR_BE,
        ];

        return $locales[$language] ?? Locale::NL_NL;
    }
}
