<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerData;
use DealerDirect\Generic\Category\EmailType;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class ReRequestContact extends Mailer
{
    use ConsumerData;

    /** @var string */
    protected $emailType = EmailType::CONSUMER_RE_REQUEST_CONTACT;

    /**
     * @param string $agentName
     * @return void
     */
    public function __invoke(string $agentName): void
    {
        $this->setData();

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
            Key::AGENT_NAME => $agentName,
            Key::LOT_NUMBER => $this->data['lot_id'],
            Key::CUSTOMER_SERVICE_PHONE => $this->getCustomerServicePhone(),
        ]);

        $this->send();
    }
}
