<?php

namespace Dealerdirect\Emails\Consumer;

use Dealerdirect\Emails\Mailer;
use Dealerdirect\Emails\Traits\ConsumerData;
use DealerDirect\Generic\Category\EmailType;
use Dealerdirect\Sdk\Model\Email\Substitutions;
use Dealerdirect\Sdk\Model\Email\SubstitutionKeys as Key;

class RequestContact extends Mailer
{
    use ConsumerData;

    public const MANUALLY = 0;
    public const FIRST_FOLLOW_UP = 1;
    public const SECOND_FOLLOW_UP = 2;

    /** @var string */
    protected $emailType;

    /**
     * @param string $agentName
     * @return void
     */
    public function __invoke(string $agentName, int $followUp = self::MANUALLY): void
    {
        $this->setData();
        $this->setEmailType($followUp);
        $this->addRecipient("{$this->data['first_name']} {$this->data['last_name']}", $this->data['email']);

        $this->substitutions = new Substitutions([
            Key::FIRST_NAME => $this->data['first_name'],
            Key::LAST_NAME => $this->data['last_name'],
            Key::VEHICLE_MAKE => $this->data['make'],
            Key::VEHICLE_MODEL => $this->data['model'],
            Key::AGENT_PHONE => $this->getGroupPhoneByLotId(),
            Key::AGENT_NAME => $agentName,
            Key::LOT_NUMBER => $this->data['id'],
            Key::CUSTOMER_SERVICE_PHONE => $this->getCustomerServicePhone(),
        ]);

        $this->send();
    }

    /**
     * @param integer $followUp
     * @return string
     */
    private function setEmailType(int $followUp): void
    {
        $types = [
            self::FIRST_FOLLOW_UP => EmailType::CONSUMER_REQUEST_CONTACT_FOLLOW_UP_FIRST,
            self::SECOND_FOLLOW_UP => EmailType::CONSUMER_REQUEST_CONTACT_FOLLOW_UP_SECOND,
        ];

        $this->emailType = $types[$followUp] ?? EmailType::CONSUMER_REQUEST_CONTACT;
    }
}
