<?php

namespace Dealerdirect\Emails\Traits;

use DealerDirect\Generic\Category\Site;

trait ConsumerDomains
{
    /** @var array */
    private $requiredDomains = [
        'carNl', 'carBe', 'carDe', 'motorNl', 'motorBe', 'motorDe', 'scooterNl',
    ];

    /** @var array */
    protected $domains;

    /**
     * Sets consumer domains
     *
     * @param array $domains
     * @return void
     */
    public function setDomains(array $domains)
    {
        foreach ($this->requiredDomains as $domainKey) {
            if (empty($domains[$domainKey])) {
                throw new \Exception("Error, missing domain '$domainKey'.");
            }

            $this->domains[$domainKey] = $domains[$domainKey];
        }
    }

    /**
     * Gets domain by reference
     *
     * @param integer $reference
     * @return void
     */
    protected function getDomainByReference(int $reference)
    {
        $references = [
            Site::REF_CAR_NL => 'carNl',
            Site::REF_CAR_BE_NL => 'carBe',
            Site::REF_CAR_DE => 'carDe',
            Site::REF_MOTO_NL => 'motorNl',
            Site::REF_MOTO_BE => 'motorBe',
            Site::REF_MOTO_DE => 'motorDe',
            Site::REF_SCOOTER_NL => 'scooterNl',
        ];

        if (!array_key_exists($reference, $references)) {
            $available = implode(', ', array_keys($references));

            throw new \Exception("Error, invalid reference '$reference'. Available: '$available'");
        }

        return $this->domains[$references[$reference]];
    }
}
