<?php

/**
 * Constants used for Fee calculations, per country
 *
 * These constant values are defined by Dealerdirect BI department.
 *
 * Formula:
 * ( base * LN( amount ) - modifier ) * 1.05
 *
 */

return [
    'nl' => [
        'feeMapping' => [
            100001 => 1000,
            90001 => 950,
            80001 => 900,
            70001 => 850,
            60001 => 800,
            50001 => 750,
            45001 => 720,
            40001 => 700,
            35001 => 680,
            30001 => 660,
            25001 => 640,
            20001 => 620,
            15001 => 600,
            10001 => 580,
            9501 => 560,
            9000 => 545,
            8501 => 530,
            8001 => 515,
            7501 => 500,
            7001 => 485,
            6501 => 470,
            6001 => 455,
            5501 => 440,
            5001 => 425,
            4501 => 410,
            4001 => 390,
            3501 => 370,
            3001 => 350,
            2501 => 330,
            2001 => 310,
            1501 => 290,
            1001 => 270,
            901 => 250,
            801 => 225,
            701 => 200,
            601 => 175,
            501 => 150,
            401 => 125,
            301 => 100,
            201 => 85,
            101 => 85,
            1 => 50,
        ],
    ],
    'de' => [
        'feeMapping' => [
            100001 => 1000,
            90001 => 950,
            80001 => 900,
            70001 => 850,
            60001 => 800,
            50001 => 750,
            45001 => 720,
            40001 => 700,
            35001 => 680,
            30001 => 660,
            25001 => 640,
            20001 => 620,
            15001 => 600,
            10001 => 580,
            9501 => 560,
            9000 => 545,
            8501 => 530,
            8001 => 515,
            7501 => 500,
            7001 => 485,
            6501 => 470,
            6001 => 455,
            5501 => 440,
            5001 => 425,
            4501 => 410,
            4001 => 390,
            3501 => 370,
            3001 => 350,
            2501 => 330,
            2001 => 310,
            1501 => 290,
            1001 => 270,
            901 => 250,
            801 => 225,
            701 => 200,
            601 => 175,
            501 => 150,
            401 => 125,
            301 => 100,
            201 => 85,
            101 => 85,
            1 => 50,
        ],
    ],
    'be' => [
        'feeMapping' => [
            100001 => 1000,
            90001 => 950,
            80001 => 900,
            70001 => 850,
            60001 => 800,
            50001 => 750,
            45001 => 720,
            40001 => 700,
            35001 => 680,
            30001 => 660,
            25001 => 640,
            20001 => 620,
            15001 => 600,
            10001 => 580,
            9501 => 560,
            9000 => 545,
            8501 => 530,
            8001 => 515,
            7501 => 500,
            7001 => 485,
            6501 => 470,
            6001 => 455,
            5501 => 440,
            5001 => 425,
            4501 => 410,
            4001 => 390,
            3501 => 370,
            3001 => 350,
            2501 => 330,
            2001 => 310,
            1501 => 290,
            1001 => 270,
            901 => 250,
            801 => 225,
            701 => 200,
            601 => 175,
            501 => 150,
            401 => 125,
            301 => 100,
            201 => 85,
            101 => 85,
            1 => 50,
        ],
    ]
];
