<?php

/**
 * Constants used for Fee calculations, per country
 *
 * These constant values are defined by Dealerdirect BI department.
 *
 * Formula:
 * ( base * LN( amount ) - modifier ) * 1.05
 *
 */
return [
    'nl' => [
        // Minimums
        'min-bare-minimum' => 85,
        'max-bare-minimum' => 85,
        'norm-bare-minimum' => 85,
        // Calc start values
        'min-base' => 77,
        'max-base' => 180,
        'norm-base' => 124,
        // Modifiers
        'min-modifier' => 350,
        'max-modifier' => 819,
        'norm-modifier' => 565,
    ],
    'be' => [
        // Minimums
        'min-bare-minimum' => 85,
        'max-bare-minimum' => 85,
        'norm-bare-minimum' => 85,
        // Calc start values
        'min-base' => 77,
        'max-base' => 180,
        'norm-base' => 124,
        // Modifiers
        'min-modifier' => 350,
        'max-modifier' => 819,
        'norm-modifier' => 565,
    ],
    'de' => [
        // Minimums
        'min-bare-minimum' => 85,
        'max-bare-minimum' => 85,
        'norm-bare-minimum' => 85,
        // Calc start values
        'min-base' => 77,
        'max-base' => 180,
        'norm-base' => 124,
        // Modifiers
        'min-modifier' => 350,
        'max-modifier' => 819,
        'norm-modifier' => 565,
    ],
];
