<?php

/**
 * Constants used for Fee calculations, per country
 *
 * These constant values are defined by Dealerdirect BI department.
 *
 * Formula:
 * ( base * LN( amount ) - modifier ) * 1.05
 *
 */

return [
    'nl' => [
        'feeMapping' => [
            50001 => 1250,
            45001 => 1200,
            40001 => 1100,
            35001 => 1000,
            30001 => 900,
            25001 => 800,
            20001 => 700,
            15001 => 650,
            12501 => 600,
            10001 => 550,
            9001 => 500,
            7001 => 450,
            5001 => 400,
            4001 => 350,
            3001 => 325,
            2001 => 300,
            1501 => 275,
            1001 => 250,
            751 => 200,
            601 => 175,
            501 => 150,
            401 => 125,
            301 => 100,
            201 => 85,
            101 => 85,
            1 => 50,
        ],
    ],
    'de' => [
        'feeMapping' => [
            50001 => 1250,
            45001 => 1200,
            40001 => 1100,
            35001 => 1000,
            30001 => 900,
            25001 => 800,
            20001 => 700,
            15001 => 650,
            12501 => 600,
            10001 => 550,
            9001 => 500,
            7001 => 450,
            5001 => 400,
            4001 => 350,
            3001 => 325,
            2001 => 300,
            1501 => 275,
            1001 => 250,
            751 => 200,
            601 => 175,
            501 => 150,
            401 => 125,
            301 => 100,
            201 => 85,
            101 => 85,
            1 => 50,
        ],
    ],
    'be' => [
        'feeMapping' => [
            50001 => 1250,
            45001 => 1200,
            40001 => 1100,
            35001 => 1000,
            30001 => 900,
            25001 => 800,
            20001 => 700,
            15001 => 650,
            12501 => 600,
            10001 => 550,
            9001 => 500,
            7001 => 450,
            5001 => 400,
            4001 => 350,
            3001 => 325,
            2001 => 300,
            1501 => 275,
            1001 => 250,
            751 => 200,
            601 => 175,
            501 => 150,
            401 => 125,
            301 => 100,
            201 => 85,
            101 => 85,
            1 => 50,
        ],
    ]
];
