<?php

/**
 * Invoice
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.4.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Dealerdirect\FinanceApiClient\Model;

use ArrayAccess;
use Dealerdirect\FinanceApiClient\ObjectSerializer;

/**
 * Invoice Class Doc Comment
 *
 * @category Class
 * @description Invoice model
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Invoice implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Invoice';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'dealerId' => 'int',
        'invoiceId' => 'string',
        'invoiceNumber' => 'int',
        'invoiceDate' => 'int',
        'amount' => 'float',
        'amountExclVat' => 'float',
        'vatAmount' => 'float',
        'status' => 'string',
        'dueDate' => 'int',
        'paidStatus' => 'string',
        'invoiceType' => 'string',
        'lines' => '\Dealerdirect\FinanceApiClient\Model\InvoiceLine[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'dealerId' => 'int',
        'invoiceId' => 'uuid',
        'invoiceNumber' => 'int64',
        'invoiceDate' => 'int',
        'amount' => 'float',
        'amountExclVat' => 'float',
        'vatAmount' => 'float',
        'status' => null,
        'dueDate' => 'int',
        'paidStatus' => 'string',
        'invoiceType' => 'string',
        'lines' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'dealerId' => false,
        'invoiceId' => false,
        'invoiceNumber' => false,
        'invoiceDate' => false,
        'amount' => false,
        'amountExclVat' => false,
        'vatAmount' => false,
        'status' => false,
        'dueDate' => false,
        'paidStatus' => false,
        'invoiceType' => false,
        'lines' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'dealerId' => 'dealer_id',
        'invoiceId' => 'invoice_id',
        'invoiceNumber' => 'invoice_number',
        'invoiceDate' => 'invoice_date',
        'amount' => 'amount',
        'amountExclVat' => 'amount_excl_vat',
        'vatAmount' => 'vat_amount',
        'status' => 'status',
        'dueDate' => 'due_date',
        'paidStatus' => 'paid_status',
        'invoiceType' => 'invoice_type',
        'lines' => 'lines'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'dealerId' => 'setDealerId',
        'invoiceId' => 'setInvoiceId',
        'invoiceNumber' => 'setInvoiceNumber',
        'invoiceDate' => 'setInvoiceDate',
        'amount' => 'setAmount',
        'amountExclVat' => 'setAmountExclVat',
        'vatAmount' => 'setVatAmount',
        'status' => 'setStatus',
        'dueDate' => 'setDueDate',
        'paidStatus' => 'setPaidStatus',
        'invoiceType' => 'setInvoiceType',
        'lines' => 'setLines'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'dealerId' => 'getDealerId',
        'invoiceId' => 'getInvoiceId',
        'invoiceNumber' => 'getInvoiceNumber',
        'invoiceDate' => 'getInvoiceDate',
        'amount' => 'getAmount',
        'amountExclVat' => 'getAmountExclVat',
        'vatAmount' => 'getVatAmount',
        'status' => 'getStatus',
        'dueDate' => 'getDueDate',
        'paidStatus' => 'getPaidStatus',
        'invoiceType' => 'getInvoiceType',
        'lines' => 'getLines'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STATUS_OPEN = 'open';
    public const STATUS_PROCESSED = 'processed';
    public const STATUS_PRINTED = 'printed';
    public const STATUS_DRAFT = 'draft';
    public const PAID_STATUS_OPEN = 'open';
    public const PAID_STATUS_PAID = 'paid';
    public const PAID_STATUS_OVERDUE = 'overdue';
    public const INVOICE_TYPE_CREDIT = 'credit';
    public const INVOICE_TYPE_DEBIT = 'debit';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_OPEN,
            self::STATUS_PROCESSED,
            self::STATUS_PRINTED,
            self::STATUS_DRAFT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPaidStatusAllowableValues()
    {
        return [
            self::PAID_STATUS_OPEN,
            self::PAID_STATUS_PAID,
            self::PAID_STATUS_OVERDUE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getInvoiceTypeAllowableValues()
    {
        return [
            self::INVOICE_TYPE_CREDIT,
            self::INVOICE_TYPE_DEBIT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('dealerId', $data ?? [], null);
        $this->setIfExists('invoiceId', $data ?? [], null);
        $this->setIfExists('invoiceNumber', $data ?? [], null);
        $this->setIfExists('invoiceDate', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('amountExclVat', $data ?? [], null);
        $this->setIfExists('vatAmount', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('dueDate', $data ?? [], null);
        $this->setIfExists('paidStatus', $data ?? [], null);
        $this->setIfExists('invoiceType', $data ?? [], null);
        $this->setIfExists('lines', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getPaidStatusAllowableValues();
        if (!is_null($this->container['paidStatus']) && !in_array($this->container['paidStatus'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'paidStatus', must be one of '%s'",
                $this->container['paidStatus'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getInvoiceTypeAllowableValues();
        if (!is_null($this->container['invoiceType']) && !in_array($this->container['invoiceType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'invoiceType', must be one of '%s'",
                $this->container['invoiceType'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets dealerId
     *
     * @return int|null
     */
    public function getDealerId()
    {
        return $this->container['dealerId'];
    }

    /**
     * Sets dealerId
     *
     * @param int|null $dealerId ID of the dealer
     *
     * @return self
     */
    public function setDealerId($dealerId)
    {
        if (is_null($dealerId)) {
            throw new \InvalidArgumentException('non-nullable dealerId cannot be null');
        }
        $this->container['dealerId'] = $dealerId;

        return $this;
    }

    /**
     * Gets invoiceId
     *
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->container['invoiceId'];
    }

    /**
     * Sets invoiceId
     *
     * @param string|null $invoiceId UUID of the invoice
     *
     * @return self
     */
    public function setInvoiceId($invoiceId)
    {
        if (is_null($invoiceId)) {
            throw new \InvalidArgumentException('non-nullable invoiceId cannot be null');
        }
        $this->container['invoiceId'] = $invoiceId;

        return $this;
    }

    /**
     * Gets invoiceNumber
     *
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoiceNumber'];
    }

    /**
     * Sets invoiceNumber
     *
     * @param int|null $invoiceNumber Invoice number
     *
     * @return self
     */
    public function setInvoiceNumber($invoiceNumber)
    {
        if (is_null($invoiceNumber)) {
            throw new \InvalidArgumentException('non-nullable invoiceNumber cannot be null');
        }
        $this->container['invoiceNumber'] = $invoiceNumber;

        return $this;
    }

    /**
     * Gets invoiceDate
     *
     * @return int|null
     */
    public function getInvoiceDate()
    {
        return $this->container['invoiceDate'];
    }

    /**
     * Sets invoiceDate
     *
     * @param int|null $invoiceDate Date of the invoice
     *
     * @return self
     */
    public function setInvoiceDate($invoiceDate)
    {
        if (is_null($invoiceDate)) {
            throw new \InvalidArgumentException('non-nullable invoiceDate cannot be null');
        }
        $this->container['invoiceDate'] = $invoiceDate;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return float|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param float|null $amount Amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets amountExclVat
     *
     * @return float|null
     */
    public function getAmountExclVat()
    {
        return $this->container['amountExclVat'];
    }

    /**
     * Sets amountExclVat
     *
     * @param float|null $amountExclVat Amount excluding VAT
     *
     * @return self
     */
    public function setAmountExclVat($amountExclVat)
    {
        if (is_null($amountExclVat)) {
            throw new \InvalidArgumentException('non-nullable amountExclVat cannot be null');
        }
        $this->container['amountExclVat'] = $amountExclVat;

        return $this;
    }

    /**
     * Gets vatAmount
     *
     * @return float|null
     */
    public function getVatAmount()
    {
        return $this->container['vatAmount'];
    }

    /**
     * Sets vatAmount
     *
     * @param float|null $vatAmount VAT amount
     *
     * @return self
     */
    public function setVatAmount($vatAmount)
    {
        if (is_null($vatAmount)) {
            throw new \InvalidArgumentException('non-nullable vatAmount cannot be null');
        }
        $this->container['vatAmount'] = $vatAmount;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status invoice status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets dueDate
     *
     * @return int|null
     */
    public function getDueDate()
    {
        return $this->container['dueDate'];
    }

    /**
     * Sets dueDate
     *
     * @param int|null $dueDate Due date of the invoice
     *
     * @return self
     */
    public function setDueDate($dueDate)
    {
        if (is_null($dueDate)) {
            throw new \InvalidArgumentException('non-nullable dueDate cannot be null');
        }
        $this->container['dueDate'] = $dueDate;

        return $this;
    }

    /**
     * Gets paidStatus
     *
     * @return string|null
     */
    public function getPaidStatus()
    {
        return $this->container['paidStatus'];
    }

    /**
     * Sets paidStatus
     *
     * @param string|null $paidStatus Payment status code
     *
     * @return self
     */
    public function setPaidStatus($paidStatus)
    {
        if (is_null($paidStatus)) {
            throw new \InvalidArgumentException('non-nullable paidStatus cannot be null');
        }
        $allowedValues = $this->getPaidStatusAllowableValues();
        if (!in_array($paidStatus, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'paidStatus', must be one of '%s'",
                    $paidStatus,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['paidStatus'] = $paidStatus;

        return $this;
    }

    /**
     * Gets invoiceType
     *
     * @return string|null
     */
    public function getInvoiceType()
    {
        return $this->container['invoiceType'];
    }

    /**
     * Sets invoiceType
     *
     * @param string|null $invoiceType Type of the invoice
     *
     * @return self
     */
    public function setInvoiceType($invoiceType)
    {
        if (is_null($invoiceType)) {
            throw new \InvalidArgumentException('non-nullable invoiceType cannot be null');
        }
        $allowedValues = $this->getInvoiceTypeAllowableValues();
        if (!in_array($invoiceType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'invoiceType', must be one of '%s'",
                    $invoiceType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['invoiceType'] = $invoiceType;

        return $this;
    }

    /**
     * Gets lines
     *
     * @return \Dealerdirect\FinanceApiClient\Model\InvoiceLine[]|null
     */
    public function getLines()
    {
        return $this->container['lines'];
    }

    /**
     * Sets lines
     *
     * @param \Dealerdirect\FinanceApiClient\Model\InvoiceLine[]|null $lines Lines on the invoice
     *
     * @return self
     */
    public function setLines($lines)
    {
        if (is_null($lines)) {
            array_push($this->openAPINullablesSetToNull, 'lines');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('lines', $nullablesSetToNull);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['lines'] = $lines;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


