<?php

/**
 * DebtorsApiTest
 * PHP version 7.2
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.2.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace Dealerdirect\FinanceApiClient\Test\Api;

use Dealerdirect\FinanceApiClient\Configuration;
use Dealerdirect\FinanceApiClient\Model\DebtorItem;

use Dealerdirect\FinanceApiClient\ApiException;
use Dealerdirect\FinanceApiClient\ObjectSerializer;
use Dealerdirect\FinanceApiClient\Client as FinanceApiClient;
use Dealerdirect\FinanceApiClient\Model\Debtor;
use PHPUnit\Framework\TestCase;

/**
 * DebtorsApiTest Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DebtorsApiTest extends TestCase
{
    private static $api = null;

    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
        $baseUrl = getenv('FINANCE_API_URL');
        $clientId = (int) getenv('FINANCE_API_CLIENT_ID');
        $clientSecret = getenv('FINANCE_API_CLIENT_SECRET');
        if ($baseUrl && $clientId && $clientSecret) {
            self::$api = (new FinanceApiClient(
                $baseUrl,
                $clientId,
                $clientSecret,
                ['write:debtors']
            ))->getDebtorsApi();
        }
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        if (is_null(self::$api)) {
            $this->markTestSkipped(
                'Api endpoint not available'
            );
        }
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for updateDebtors
     *
     * Update debtor information.
     *
     */
    public function testUpdateDebtors()
    {
        $debtor = [
            'dealerId' => 999,
            'activeDealer' => true,
            'name' => 'Dealerdirect BV',
            'countryCode' => 'NL',
            'province' => 'Overijssel',
            'city' => 'Enschede',
            'address' => 'Josink Maatweg 43',
            'postalCode' => '7545 PS',
            'email' => 'boekhouding@dealerdirect.nl',
            'phone' => '+31643888884',
            'vatNumber' => 'NL814032369B01',
            'cocNumber' => '08122057',
        ];
        $this->assertNotNull(self::$api);
        $apires = self::$api->updateDebtors(
            'nl',
            'car',
            [
                new Debtor($debtor)
            ],
            false,
        );
        $this->assertIsArray(
            $apires,
            "updateDebtors should return an array"
        );
        $this->assertCount(
            1,
            $apires,
            "updateDebtors should return an array of 1 element"
        );
        $item = reset($apires);
        $this->assertIsObject($item, "Result item  should be an object");
        $this->assertInstanceOf(DebtorItem::class, $item, "Result item should be a DebtorItem");
        $this->assertInstanceOf(Debtor::class, $item['data'], "Result item data should be a Debtor");
        $this->assertThat(
            $item['result'],
            $this->logicalOr(
                $this->equalTo("ignored"),
                $this->equalTo("queued-update"),
            ),
            "Result should be ignored or queued-update"
        );

        foreach (array_keys($debtor) as $key) {
            $value = $item['data'][$key];
            $this->assertEquals($debtor[$key], $value, "Expected $key to be equal");
        }
    }
}
