# Dealerdirect\FinanceApiClient\InvoicesApi

Client to communicate with the Dealerdirect Finance-API

All URIs are relative to http://localhost.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createInvoice()**](InvoicesApi.md#createInvoice) | **POST** /api/{country}/{vehicleType}/invoices | create an invoice(line)
[**getInvoiceDetails()**](InvoicesApi.md#getInvoiceDetails) | **GET** /api/{country}/{vehicleType}/invoices/{invoiceProviderId} | get invoice with line details
[**getInvoiceList()**](InvoicesApi.md#getInvoiceList) | **GET** /api/{country}/{vehicleType}/invoices | get invoices of dealer
[**getInvoicePDFByID()**](InvoicesApi.md#getInvoicePDFByID) | **GET** /api/{country}/{vehicleType}/invoices/{invoiceProviderId}/pdf | Get an invoice in PDF


## `createInvoice()`

```php
createInvoice($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId): \Dealerdirect\FinanceApiClient\Model\InlineResponse200
```

create an invoice(line)

creates an invoice(line) for a delivery

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\InvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$country = nl; // string
$vehicleType = car; // string
$lotId = 56; // int | Id of the lot sold
$unitPrice = 56; // int | Price of the unit aka fee
$quantity = 56; // int | Quantity
$licensePlate = 'licensePlate_example'; // string | License plate
$constructionYear = 'constructionYear_example'; // string | Construction year
$make = 'make_example'; // string | Make
$model = 'model_example'; // string | model
$makeAndModel = 'makeAndModel_example'; // string | Make and model
$description = 'description_example'; // string | General description for invoice line
$dealerId = 56; // int | Id of the dealer buying the lot

try {
    $result = $apiInstance->createInvoice($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoicesApi->createInvoice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **country** | **string**|  |
 **vehicleType** | **string**|  |
 **lotId** | **int**| Id of the lot sold | [optional]
 **unitPrice** | **int**| Price of the unit aka fee | [optional]
 **quantity** | **int**| Quantity | [optional]
 **licensePlate** | **string**| License plate | [optional]
 **constructionYear** | **string**| Construction year | [optional]
 **make** | **string**| Make | [optional]
 **model** | **string**| model | [optional]
 **makeAndModel** | **string**| Make and model | [optional]
 **description** | **string**| General description for invoice line | [optional]
 **dealerId** | **int**| Id of the dealer buying the lot | [optional]

### Return type

[**\Dealerdirect\FinanceApiClient\Model\InlineResponse200**](../Model/InlineResponse200.md)

### Authorization

[passport](../../README.md#passport)

### HTTP request headers

- **Content-Type**: `multipart/form-data`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInvoiceDetails()`

```php
getInvoiceDetails($country, $vehicleType, $invoiceProviderId, $dealerId): \Dealerdirect\FinanceApiClient\Model\Invoice[]
```

get invoice with line details

Returns an invoice, with all details

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\InvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$country = nl; // string
$vehicleType = car; // string
$invoiceProviderId = xxxxxxxx-xxxx-4xxx-xxxx-xxxxxxxxxxxx; // string
$dealerId = 9999; // int | Filter invoices on provided dealer id

try {
    $result = $apiInstance->getInvoiceDetails($country, $vehicleType, $invoiceProviderId, $dealerId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoicesApi->getInvoiceDetails: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **country** | **string**|  |
 **vehicleType** | **string**|  |
 **invoiceProviderId** | **string**|  |
 **dealerId** | **int**| Filter invoices on provided dealer id |

### Return type

[**\Dealerdirect\FinanceApiClient\Model\Invoice[]**](../Model/Invoice.md)

### Authorization

[passport](../../README.md#passport)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInvoiceList()`

```php
getInvoiceList($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus): \Dealerdirect\FinanceApiClient\Model\Invoice[]
```

get invoices of dealer

Returns a list of invoiced of a Dealer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\InvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$country = nl; // string
$vehicleType = car; // string
$year = 2020; // int | Filter invoices on provided year
$paidStatus = paid; // string | Filter invoices on provided paid status
$invoiceType = debit; // string | Filter invoices on provided paid invoice type
$dealerId = 9999; // int | Filter invoices on provided dealer id
$invoiceStatus = processed; // string | Filter invoices on provided invoice status

try {
    $result = $apiInstance->getInvoiceList($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoicesApi->getInvoiceList: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **country** | **string**|  |
 **vehicleType** | **string**|  |
 **year** | **int**| Filter invoices on provided year | [optional]
 **paidStatus** | **string**| Filter invoices on provided paid status | [optional]
 **invoiceType** | **string**| Filter invoices on provided paid invoice type | [optional]
 **dealerId** | **int**| Filter invoices on provided dealer id | [optional]
 **invoiceStatus** | **string**| Filter invoices on provided invoice status | [optional]

### Return type

[**\Dealerdirect\FinanceApiClient\Model\Invoice[]**](../Model/Invoice.md)

### Authorization

[passport](../../README.md#passport)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInvoicePDFByID()`

```php
getInvoicePDFByID($country, $vehicleType, $invoiceProviderId, $dealerId): \SplFileObject
```

Get an invoice in PDF

Returns a PDF for an invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\InvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$country = nl; // string
$vehicleType = car; // string
$invoiceProviderId = xxxxxxxx-xxxx-4xxx-xxxx-xxxxxxxxxxxx; // string
$dealerId = 9999; // int | ID of the dealer the invoice was meant for

try {
    $result = $apiInstance->getInvoicePDFByID($country, $vehicleType, $invoiceProviderId, $dealerId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoicesApi->getInvoicePDFByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **country** | **string**|  |
 **vehicleType** | **string**|  |
 **invoiceProviderId** | **string**|  |
 **dealerId** | **int**| ID of the dealer the invoice was meant for | [optional]

### Return type

[**\SplFileObject**](../Model/\SplFileObject.md)

### Authorization

[passport](../../README.md#passport)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/pdf`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
