<?php

/**
 * HealthcheckApiTest
 * PHP version 7.2
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.2.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace Dealerdirect\FinanceApiClient\Test\Api;

use Dealerdirect\FinanceApiClient\Configuration;
use Dealerdirect\FinanceApiClient\Client as FinanceApiClient;
use Dealerdirect\FinanceApiClient\Api\HealthcheckApi;
use Dealerdirect\FinanceApiClient\ApiException;
use Dealerdirect\FinanceApiClient\ObjectSerializer;
use PHPUnit\Framework\TestCase;

/**
 * HealthcheckApiTest Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class HealthcheckApiTest extends TestCase
{
    private static $api = null;

    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
        $baseUrl = getenv('FINANCE_API_URL');
        $clientId = (int) getenv('FINANCE_API_CLIENT_ID');
        $clientSecret = getenv('FINANCE_API_CLIENT_SECRET');
        if ($baseUrl && $clientId && $clientSecret) {
            self::$api = (new FinanceApiClient(
                $baseUrl,
                $clientId,
                $clientSecret,
                ['']
            ))->getHealthcheckApi();
        }
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        if (is_null(self::$api)) {
            $this->markTestSkipped(
                'Api endpoint not available'
            );
        }
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for healthcheck
     *
     * Check for checking of the api is healthy.
     *
     */
    public function testHealthcheck()
    {
        $this->assertNotNull(self::$api);
        $apires = self::$api->healthcheck();
        $this->assertEquals(
            "all systems up and running\n",
            $apires,
            "Healthcheck message doesn't match expected output"
        );
    }
}
