# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.2 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/dealerdirect/finance-api-client.git"
    }
  ],
  "require": {
    "dealerdirect/finance-api-client": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\HealthcheckApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $apiInstance->healthcheck();
} catch (Exception $e) {
    echo 'Exception when calling HealthcheckApi->healthcheck: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*HealthcheckApi* | [**healthcheck**](docs/Api/HealthcheckApi.md#healthcheck) | **GET** /health-check | Check for checking of the api is healthy
*InvoicesApi* | [**createInvoice**](docs/Api/InvoicesApi.md#createinvoice) | **POST** /api/{country}/{vehicleType}/invoice | create an invoice(line)
*InvoicesApi* | [**getInvoiceListByDealer**](docs/Api/InvoicesApi.md#getinvoicelistbydealer) | **GET** /api/{country}/{vehicleType}/invoice/{dealerId} | get invoices of dealer
*InvoicesApi* | [**getInvoicePDFByID**](docs/Api/InvoicesApi.md#getinvoicepdfbyid) | **GET** /api/{country}/{vehicleType}/invoice/{dealerId}/{invoiceNumber}/pdf | Get a invoice in PDF

## Models

- [Invoice](docs/Model/Invoice.md)

## Authorization

### passport

- **Type**: `OAuth`
- **Flow**: `application`
- **Authorization URL**: ``
- **Scopes**: 
    - **read:invoices**: get invoice data
    - **write:invoices**: write invoice data

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `1.0.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
