# Dealerdirect\FinanceApiClient\HealthcheckApi

Client to communicate with the Dealerdirect Finance-API

All URIs are relative to http://localhost.

Method | HTTP request | Description
------------- | ------------- | -------------
[**healthcheck()**](HealthcheckApi.md#healthcheck) | **GET** /health-check | Check for checking of the api is healthy


## `healthcheck()`

```php
healthcheck(): string
```

Check for checking of the api is healthy

Returns 'all systems up and running\\n' when healthy

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\HealthcheckApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->healthcheck();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HealthcheckApi->healthcheck: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**string**

### Authorization

[passport](../../README.md#passport)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `text/plain`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
